/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.configapi.client.screen.widget;

import com.craftjakob.configapi.config.ConfigValueTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.NonNull;

public class ConfigEditBox<T>
extends EditBox {
    private final ConfigValueTypes.ConfigValue<T> config;
    private boolean valid = true;

    public ConfigEditBox(Font font, int width, int height, int x, int y, ConfigValueTypes.ConfigValue<T> config) {
        super(font, width, height, x, y, (Component)Component.literal((String)config.getKey()));
        this.config = config;
        this.setHint((Component)Component.literal((String)"Set here...").withStyle(ChatFormatting.DARK_GRAY));
        this.setMaxLength(127);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        boolean isMouseCurrentlyOver = super.isMouseOver(mouseX, mouseY);
        if (!isMouseCurrentlyOver && this.isFocused()) {
            this.setFocused(false);
        }
        return super.isMouseOver(mouseX, mouseY);
    }

    public boolean mouseClicked(@NonNull MouseButtonEvent event, boolean flag) {
        if (!this.isMouseOver(event.x(), event.y()) && this.isFocused()) {
            this.setFocused(false);
        }
        if (this.isVisible() && event.button() == 1) {
            this.setValue("");
        }
        return super.mouseClicked(event, flag);
    }

    public boolean keyPressed(KeyEvent event) {
        if (event.key() == 257) {
            this.setFocused(false);
        }
        return super.keyPressed(event);
    }

    public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        if (!this.valid && this.visible) {
            int color = -65536;
            this.setTextColor(color);
            graphics.fill(this.getX() - 1, this.getY() - 1, this.getX() + this.width + 1, this.getY(), color);
            graphics.fill(this.getX() - 1, this.getY() - 1, this.getX(), this.getY() + this.height + 1, color);
            graphics.fill(this.getX() + this.width, this.getY() - 1, this.getX() + this.width + 1, this.getY() + this.height + 1, color);
            graphics.fill(this.getX() - 1, this.getY() + this.height, this.getX() + this.width + 1, this.getY() + this.height + 1, color);
        } else {
            this.setTextColor(-1);
        }
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public ConfigValueTypes.ConfigValue<T> getConfig() {
        return this.config;
    }

    public boolean isValid() {
        return this.valid;
    }
}

