/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.configapi.client.screen.widget;

import com.craftjakob.configapi.client.screen.list.ValueList;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import org.jspecify.annotations.NonNull;

public class SearchBox
extends EditBox {
    private static final Identifier SEARCH_MAGNIFIER = Identifier.fromNamespaceAndPath((String)"configapi", (String)"textures/gui/widget/search_magnifier.png");
    private static final Identifier SEARCH_MAGNIFIER_HIGHLIGHTED = Identifier.fromNamespaceAndPath((String)"configapi", (String)"textures/gui/widget/search_magnifier_highlighted.png");
    private static final Identifier CANCEL = Identifier.fromNamespaceAndPath((String)"configapi", (String)"textures/gui/widget/cancel.png");
    private static final Identifier CANCEL_HIGHLIGHTED = Identifier.fromNamespaceAndPath((String)"configapi", (String)"textures/gui/widget/cancel_highlighted.png");

    public SearchBox(Font font, int width, int height, int x, int y) {
        super(font, width, height, x, y, (Component)Component.translatable((String)"itemGroup.search"));
        this.setHint((Component)Component.literal((String)"Search...").withStyle(ChatFormatting.DARK_GRAY));
        this.setTooltip(Tooltip.create((Component)Component.literal((String)"Search for the tooltip with '#'")));
        this.setTooltipDelay(Duration.ofSeconds(3L));
    }

    public boolean mouseClicked(@NonNull MouseButtonEvent event, boolean flag) {
        if (this.visible && (event.button() == 1 || this.isMouseOverImage(event.x(), event.y()))) {
            this.setValue("");
            return true;
        }
        return super.mouseClicked(event, flag);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        boolean isMouseCurrentlyOver;
        boolean bl = isMouseCurrentlyOver = this.visible && mouseX >= (double)this.getX() && mouseX < (double)(this.getX() + this.width) && mouseY >= (double)this.getY() && mouseY < (double)(this.getY() + this.height);
        if (!isMouseCurrentlyOver && this.isFocused()) {
            this.setFocused(false);
        }
        return isMouseCurrentlyOver;
    }

    public boolean keyPressed(@NonNull KeyEvent event) {
        if (event.key() == 256) {
            this.setFocused(false);
        }
        return super.keyPressed(event);
    }

    public void renderWidget(@NonNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        Identifier texture = !this.isTextFiledEmpty() ? (this.isHovered() && this.isMouseOverImage(mouseX, mouseY) ? CANCEL_HIGHLIGHTED : CANCEL) : (this.isHovered() && this.isMouseOverImage(mouseX, mouseY) ? SEARCH_MAGNIFIER_HIGHLIGHTED : SEARCH_MAGNIFIER);
        graphics.blit(RenderPipelines.GUI_TEXTURED, texture, this.getX() + this.getWidth() - 20, this.getY(), 0.0f, 0.0f, 20, 20, 20, 20);
    }

    public boolean isMouseOverImage(double mouseX, double mouseY) {
        int imageX = this.getX() + this.getWidth() - 20;
        int imageY = this.getY();
        int imageWidth = 20;
        int imageHeight = 20;
        return this.isVisible() && mouseX >= (double)imageX && mouseX < (double)(imageX + imageWidth) && mouseY >= (double)imageY && mouseY < (double)(imageY + imageHeight);
    }

    public boolean isTextFiledEmpty() {
        return this.getValue().isEmpty();
    }

    public void updateSearchTextFieldSuggestion(SearchBox searchBox, String searchText, List<? extends ValueList.Entry<?>> entries) {
        if (!searchText.isEmpty()) {
            Optional<ValueList.Entry> optional = entries.stream().filter(info -> info.getEntryName().toLowerCase().contains(searchText.toLowerCase())).findFirst();
            if (optional.isPresent()) {
                String displayName = optional.get().getEntryName();
                int index = displayName.toLowerCase().indexOf(searchText.toLowerCase());
                searchBox.setSuggestion(displayName.substring(index + searchText.length()));
            } else {
                searchBox.setSuggestion("");
            }
        } else {
            searchBox.setSuggestion("");
        }
    }
}

