/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.configapi.config;

import com.craftjakob.configapi.ConfigAPI;
import com.craftjakob.configapi.config.ConfigBuilder;
import com.craftjakob.configapi.config.ConfigData;
import com.craftjakob.configapi.config.ConfigFileWriter;
import com.craftjakob.configapi.config.ConfigTracker;
import com.craftjakob.configapi.config.ConfigValueTypes;
import com.craftjakob.configapi.config.IConfigurator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class Config {
    private final String modId;
    private final ConfigType type;
    private final IConfigurator configurator;
    private final boolean isTracked;
    private final String filePath;
    private File configFile;
    private ConfigData configData;

    protected Config(String modId, ConfigType type, IConfigurator configurator, boolean isTracked, String filePath) {
        this.modId = modId;
        this.type = type;
        this.configurator = configurator;
        this.isTracked = isTracked;
        this.filePath = filePath;
        this.configData = this.configureConfigData(configurator);
        ConfigTracker.get().trackConfig(this);
    }

    public ConfigData configureConfigData(IConfigurator configurator) {
        ConfigBuilder builder = new ConfigBuilder();
        builder.setConfig(this);
        configurator.configure(builder);
        ConfigBuilder configBuilder = configurator.getConfigBuilder();
        if (configBuilder != null) {
            configBuilder.setConfig(this);
            builder.addConfigData(configBuilder.build());
        }
        return builder.build();
    }

    public String getModId() {
        return this.modId;
    }

    public ConfigType getType() {
        return this.type;
    }

    public IConfigurator getConfigurator() {
        return this.configurator;
    }

    public boolean isTracked() {
        return this.isTracked;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getFileName() {
        int lastSlashIndex = this.filePath.lastIndexOf(47);
        return lastSlashIndex == -1 ? this.filePath : this.filePath.substring(lastSlashIndex + 1);
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public ConfigData getConfigData() {
        return this.configData;
    }

    public static String configName(String modId, ConfigType type) {
        return String.format("%s-%s", modId, type.extension());
    }

    public static String configPath(String modId, ConfigType type, String filePath) {
        if (filePath.endsWith("/")) {
            return filePath + Config.configName(modId, type) + ".cfg";
        }
        return filePath + ".cfg";
    }

    public void setConfigData(ConfigData configData) {
        this.configData = configData;
    }

    public void setConfigFile(Path configPath) {
        this.configFile = new File(String.valueOf(configPath) + "/" + this.filePath);
    }

    public void clearServerConfigData() {
        this.configData = null;
    }

    public boolean allConfigsOnDefault() {
        return this.configData.getConfigValues().values().stream().allMatch(ConfigValueTypes.ConfigValue::isDefaultValue);
    }

    public void resetAllConfigs() {
        this.configData.getConfigValues().forEach((key, configValue) -> configValue.setToDefault());
        this.save();
    }

    public <T> void setValueWithoutSave(String key, T newValue) {
        ConfigValueTypes.ConfigValue<?> configValue = this.configData.getConfigValues().get(key);
        if (configValue == null) {
            throw new IllegalArgumentException("There is no config value with key: " + key);
        }
        configValue.setValueWithoutSave(newValue);
    }

    public <T> void setValue(String key, T newValue) {
        ConfigValueTypes.ConfigValue<?> configValue = this.configData.getConfigValues().get(key);
        if (configValue == null) {
            throw new IllegalArgumentException("There is no config value with key: " + key);
        }
        configValue.setValue(newValue);
    }

    public <T> T getValue(String key) {
        ConfigValueTypes.ConfigValue<?> configValue = this.configData.getConfigValues().get(key);
        if (configValue != null) {
            return (T)configValue.getValue();
        }
        throw new IllegalArgumentException("There is no config value with key: " + key);
    }

    public void stopTracking() {
        if (this.isTracked) {
            ConfigTracker.get().stopTrackingConfig(this);
        }
    }

    public void load() {
        block16: {
            if (this.configFile.exists()) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(this.configFile));
                    block11: while (true) {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            int equalsIndex;
                            if ((line = line.trim()).isEmpty() || line.startsWith("#") || (equalsIndex = line.indexOf(61)) == -1) continue;
                            String key = line.substring(0, equalsIndex).trim();
                            String value = line.substring(equalsIndex + 1).trim();
                            ConfigValueTypes.ConfigValue<?> configValue = this.configData.getConfigValues().get(key);
                            try {
                                configValue.loadValueFromString(value);
                                continue block11;
                            }
                            catch (Exception e) {
                                ConfigAPI.LOGGER.error("Failed to load value for key: " + key + " - Might be an old config, which is now deleted from the configFile.", (Throwable)e);
                            }
                        }
                        break block16;
                        {
                            continue block11;
                            break;
                        }
                        break;
                    }
                    finally {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    ConfigAPI.LOGGER.error("Failed to load config file: " + String.valueOf(this.configFile), (Throwable)e);
                }
            } else if (!this.configFile.getParentFile().exists()) {
                try {
                    Files.createDirectories(this.configFile.toPath().getParent(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to create directory for config file: " + String.valueOf(this.configFile), e);
                }
            }
        }
    }

    public void save() {
        try (ConfigFileWriter writer = new ConfigFileWriter(this.configFile);){
            writer.write("#" + this.getModId() + " " + this.getType().extension() + " configuration");
            writer.newLine();
            writer.newLine();
            writer.newLine();
            writer.writeConfig(this.configData);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save config file '" + String.valueOf(this.configFile) + "'", e);
        }
    }

    public static enum ConfigType {
        CLIENT,
        COMMON,
        SERVER;


        public String extension() {
            return this.name().toLowerCase();
        }

        public String getFormattedName() {
            return this.name().substring(0, 1).toUpperCase() + this.name().substring(1).toLowerCase();
        }
    }
}

