/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.configapi.config;

import com.craftjakob.configapi.config.ConfigData;
import com.craftjakob.configapi.config.ConfigValueTypes;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public class ConfigFileWriter
extends FileWriter {
    public ConfigFileWriter(File configFile) throws IOException {
        super(configFile);
    }

    public void newLine() throws IOException {
        this.write(EscapeSequences.NEXT_LINE.getCharacter());
    }

    public void writeConfig(ConfigData configData) throws IOException {
        String lastCategory = null;
        for (ConfigValueTypes.ConfigValue<?> configValue : configData.getConfigValues().values()) {
            String category = String.join((CharSequence)".", configValue.getPath().subList(0, configValue.getPath().size() - 1));
            if (!category.equals(lastCategory)) {
                if (lastCategory != null) {
                    this.write(EscapeSequences.NEXT_LINE.getCharacter());
                }
                if (!category.isEmpty()) {
                    List<String> categoryComments;
                    this.write(this.createComments(categoryComments, (categoryComments = configData.getCategoryComments().get(configValue.getPath().subList(0, configValue.getPath().size() - 1))) != null, configValue.getPath().size() - 2));
                    this.write(this.generateIndent(configValue.getPath().size() - 2) + "[" + category + "]");
                    this.write(EscapeSequences.NEXT_LINE.getCharacter());
                }
                lastCategory = category;
            }
            this.write(this.createConfigValue(configValue));
        }
    }

    private String createConfigValue(ConfigValueTypes.ConfigValue<?> config) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.createComments(config.getComments(), config.hasComments(), config.getPath().size() - 1));
        sb.append(this.createKeyValue(config));
        return sb.toString();
    }

    private String createComments(List<String> comments, boolean hasComments, int indent) {
        StringBuilder sb = new StringBuilder();
        if (hasComments) {
            for (String comment : comments) {
                sb.append(this.generateIndent(indent));
                sb.append('#');
                sb.append(comment);
                sb.append(EscapeSequences.NEXT_LINE.getCharacter());
            }
        }
        return sb.toString();
    }

    private String createKeyValue(ConfigValueTypes.ConfigValue<?> config) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.generateIndent(config.getPath().size() - 1));
        sb.append(config.getKey());
        sb.append(" = ");
        sb.append(this.formatValue(config.getValue()));
        sb.append(EscapeSequences.NEXT_LINE.getCharacter());
        return sb.toString();
    }

    private String formatValue(Object value) {
        if (value instanceof Enum) {
            Enum enumValue = (Enum)value;
            return enumValue.name();
        }
        return value.toString();
    }

    private String generateIndent(int indentLevel) {
        return String.valueOf(EscapeSequences.TAB.getCharacter()).repeat(indentLevel);
    }

    public static enum EscapeSequences {
        TAB('\t'),
        NEXT_LINE('\n');

        private final char character;

        private EscapeSequences(char character) {
            this.character = character;
        }

        public char getCharacter() {
            return this.character;
        }
    }
}

