/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.configapi.config;

import com.craftjakob.configapi.ConfigAPI;
import com.craftjakob.configapi.config.Config;
import com.craftjakob.configapi.config.ConfigBuilder;
import com.craftjakob.configapi.config.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class ConfigValueTypes {

    public static class DoubleValue
    extends NumberValue<Double> {
        public DoubleValue(ConfigBuilder builder, List<String> path, Double defaultValue, double minValue, double maxValue) {
            super(builder, path, defaultValue, new Range<Double>(minValue, maxValue), Double::parseDouble);
        }
    }

    public static class FloatValue
    extends NumberValue<Float> {
        public FloatValue(ConfigBuilder builder, List<String> path, Float defaultValue, float minValue, float maxValue) {
            super(builder, path, defaultValue, new Range<Float>(Float.valueOf(minValue), Float.valueOf(maxValue)), Float::parseFloat);
        }
    }

    public static class LongValue
    extends NumberValue<Long> {
        public LongValue(ConfigBuilder builder, List<String> path, Long defaultValue, long minValue, long maxValue) {
            super(builder, path, defaultValue, new Range<Long>(minValue, maxValue), Long::parseLong);
        }
    }

    public static class IntegerValue
    extends NumberValue<Integer> {
        public IntegerValue(ConfigBuilder builder, List<String> path, Integer defaultValue, int minValue, int maxValue) {
            super(builder, path, defaultValue, new Range<Integer>(minValue, maxValue), Integer::parseInt);
        }
    }

    public static class ShortValue
    extends NumberValue<Short> {
        public ShortValue(ConfigBuilder builder, List<String> path, Short defaultValue, short minValue, short maxValue) {
            super(builder, path, defaultValue, new Range<Short>(minValue, maxValue), Short::parseShort);
        }
    }

    public static class ByteValue
    extends NumberValue<Byte> {
        public ByteValue(ConfigBuilder builder, List<String> path, Byte defaultValue, byte minValue, byte maxValue) {
            super(builder, path, defaultValue, new Range<Byte>(minValue, maxValue), Byte::parseByte);
        }
    }

    public static class NumberValue<T extends Number>
    extends ConfigValue<T> {
        private Range<T> range;

        public NumberValue(ConfigBuilder builder, List<String> path, T defaultValue, Range<T> range, Function<String, T> parser) {
            super(builder, path, defaultValue, parser);
            this.range = range;
        }

        public Range<T> getRange() {
            return this.range;
        }

        public void setRange(T minValue, T maxValue) {
            if (((Comparable)minValue).compareTo(maxValue) > 0) {
                throw new IllegalArgumentException(String.format("The minValue %s cannot be greater than the maxValue %s or the maxValue %s cannot be less than the minValue %s", minValue, maxValue, maxValue, minValue));
            }
            this.range = new Range<T>(minValue, maxValue);
        }

        public boolean isInRange(T value) {
            return ((Comparable)value).compareTo(this.range.getMinValue()) >= 0 && ((Comparable)value).compareTo(this.range.getMaxValue()) <= 0;
        }

        @Override
        public void setValue(T newValue) {
            this.correctValue(newValue);
        }

        public void correctValue(T value) {
            if (((Comparable)value).compareTo(this.range.getMinValue()) < 0) {
                ConfigAPI.LOGGER.warn("The value " + String.valueOf(value) + " of '" + this.getKey() + "' is below the minimum value " + String.valueOf(this.range.getMinValue()) + ", set it to the minimum value: " + String.valueOf(this.range.getMinValue()));
                super.setValue((Number)this.range.getMinValue());
            } else if (((Comparable)value).compareTo(this.range.getMaxValue()) > 0) {
                ConfigAPI.LOGGER.warn("The value " + String.valueOf(value) + " of '" + this.getKey() + "' is above the maximum value " + String.valueOf(this.range.getMaxValue()) + ", set it to the maximum value: " + String.valueOf(this.range.getMaxValue()));
                super.setValue((Number)this.range.getMaxValue());
            } else {
                super.setValue(value);
            }
        }
    }

    public static class ListValue<T>
    extends ConfigValue<List<T>> {
        public ListValue(ConfigBuilder builder, List<String> path, List<T> defaultValue, Function<String, T> elementParser) {
            super(builder, path, defaultValue != null ? new ArrayList<T>(defaultValue) : new ArrayList(), (String s) -> {
                if (s.startsWith("[")) {
                    s = s.substring(1);
                }
                if (s.endsWith("]")) {
                    s = s.substring(0, s.length() - 1);
                }
                return Arrays.stream(s.trim().split(", ")).map(elementParser).collect(Collectors.toList());
            });
        }

        public T getValueAtIndex(int index) {
            return (T)((List)this.getValue()).get(index);
        }
    }

    public static class EnumValue<E extends Enum<E>>
    extends ConfigValue<E> {
        private final Class<E> enumClass;

        public EnumValue(ConfigBuilder builder, List<String> path, E defaultValue) {
            super(builder, path, defaultValue, s -> Enum.valueOf(defaultValue.getDeclaringClass(), s));
            this.enumClass = ((Enum)defaultValue).getDeclaringClass();
        }

        public Class<E> getEnumClass() {
            return this.enumClass;
        }

        public E[] getValues() {
            return (Enum[])this.enumClass.getEnumConstants();
        }
    }

    public static class StringValue
    extends ConfigValue<String> {
        public StringValue(ConfigBuilder builder, List<String> path, String defaultValue) {
            super(builder, path, defaultValue, String::valueOf);
        }
    }

    public static class CharacterValue
    extends ConfigValue<Character> {
        public CharacterValue(ConfigBuilder builder, List<String> path, Character defaultValue) {
            super(builder, path, defaultValue, s -> {
                if (s.length() >= 2) {
                    throw new IllegalArgumentException("Input String must be exactly one character long");
                }
                return Character.valueOf(s.charAt(0));
            });
        }
    }

    public static class BooleanValue
    extends ConfigValue<Boolean> {
        public BooleanValue(ConfigBuilder builder, List<String> path, Boolean defaultValue) {
            super(builder, path, defaultValue, Boolean::parseBoolean);
        }
    }

    public static class ConfigValue<T> {
        private final ConfigBuilder builder;
        private final List<String> path;
        private final T defaultValue;
        private T value;
        private final List<String> comments;
        private final String translationKey;
        private final boolean requiresWorldRestart;
        private final boolean requiresClientRestart;
        private final boolean requiresRestart;
        private final Function<String, T> parser;
        private final Config config;

        public ConfigValue(ConfigBuilder builder, List<String> path, T defaultValue, Function<String, T> parser) {
            this.builder = builder;
            this.path = path;
            this.defaultValue = defaultValue;
            this.value = defaultValue;
            this.comments = builder.context.getComments();
            this.translationKey = builder.context.getTranslationKey();
            this.requiresWorldRestart = builder.context.getRequiresWorldRestart();
            this.requiresClientRestart = builder.context.getRequiresClientRestart();
            this.requiresRestart = builder.context.getRequiresRestart();
            this.parser = parser;
            this.config = builder.config;
        }

        public boolean hasComments() {
            return this.comments != null && !this.comments.isEmpty();
        }

        public boolean hasTranslationKey() {
            return this.translationKey != null && !this.translationKey.isEmpty();
        }

        public boolean isSameValue(T checkValue) {
            return checkValue == this.value;
        }

        public boolean isDefaultValue() {
            return this.getValue().equals(this.getDefaultValue());
        }

        public ConfigBuilder getBuilder() {
            return this.builder;
        }

        public List<String> getPath() {
            return new ArrayList<String>(this.path);
        }

        public String getKey() {
            return this.path.getLast();
        }

        public T getDefaultValue() {
            return this.defaultValue;
        }

        public T getValue() {
            return this.value;
        }

        public List<String> getComments() {
            return this.comments;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public boolean getRequiresWorldRestart() {
            return this.requiresWorldRestart;
        }

        public boolean getRequiresClientRestart() {
            return this.requiresClientRestart;
        }

        public boolean getRequiresRestart() {
            return this.requiresRestart;
        }

        public Function<String, T> getParser() {
            return this.parser;
        }

        public Config getConfig() {
            return this.config;
        }

        public void setValue(T newValue) {
            try {
                this.value = newValue;
                this.config.save();
            }
            catch (Exception e) {
                ConfigAPI.LOGGER.error("Illegal value: '" + String.valueOf(newValue) + "', for key: " + this.getKey());
            }
        }

        public void setValueWithoutSave(T newValue) {
            try {
                this.value = newValue;
            }
            catch (Exception e) {
                ConfigAPI.LOGGER.error("Illegal value: '" + String.valueOf(newValue) + "', for key: " + this.getKey());
            }
        }

        public void loadValueFromString(String valueAsString) {
            try {
                this.setValueWithoutSave(this.parser.apply(valueAsString));
            }
            catch (Exception e) {
                ConfigAPI.LOGGER.error("Failed to load value: {}", (Object)valueAsString, (Object)e);
            }
        }

        public void setToDefault() {
            this.value = this.defaultValue;
        }
    }
}

