/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.configapi.config.network;

import com.craftjakob.configapi.config.ConfigTracker;
import com.craftjakob.configapi.config.network.ConfigPacketPayload;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;

public final class ConfigNetwork {
    private ConfigNetwork() {
    }

    public static List<ConfigPacketPayload> getConfigSync() {
        Map<String, byte[]> configData = ConfigTracker.get().getConfigSync();
        if (configData.isEmpty()) {
            return new ArrayList<ConfigPacketPayload>();
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeMap(configData, FriendlyByteBuf::writeUtf, (o, bytes) -> o.writeByteArray(bytes));
        return configData.entrySet().stream().map(entry -> new ConfigPacketPayload((String)entry.getKey(), (byte[])entry.getValue())).toList();
    }

    public static void acceptSyncedConfigs(String filePath, byte[] data) {
        if (!Minecraft.getInstance().isLocalServer()) {
            ConfigTracker.get().acceptSyncedConfigs(filePath, data);
        }
    }
}

