/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.event;

import com.craftjakob.event.Event;
import com.craftjakob.event.EventResult;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.world.InteractionResult;

public final class EventFactory {
    private EventFactory() {
    }

    @SafeVarargs
    public static <T> Event<T> createEventResultValue(T ... typeGetter) {
        return EventFactory.create(priorityListeners -> (proxy, method, args) -> {
            for (ArrayList listeners : priorityListeners.values()) {
                for (Object listener : listeners) {
                    EventResult.Value value = Objects.requireNonNull((EventResult.Value)EventFactory.invokeEventMethod(listener, method, args));
                    if (!value.result().interrupts()) continue;
                    return value;
                }
            }
            return EventResult.PASS.with(null);
        }, typeGetter);
    }

    @SafeVarargs
    public static <T> Event<T> createEventResult(T ... typeGetter) {
        return EventFactory.create(priorityListeners -> (proxy, method, args) -> {
            for (ArrayList listeners : priorityListeners.values()) {
                for (Object listener : listeners) {
                    EventResult result = Objects.requireNonNull((EventResult)((Object)((Object)((Object)EventFactory.invokeEventMethod(listener, method, args)))));
                    if (!result.interrupts()) continue;
                    return result;
                }
            }
            return EventResult.PASS;
        }, typeGetter);
    }

    @SafeVarargs
    public static <T> Event<T> createInteractionResult(T ... typeGetter) {
        return EventFactory.create(priorityListeners -> (proxy, method, args) -> {
            for (ArrayList listeners : priorityListeners.values()) {
                for (Object listener : listeners) {
                    InteractionResult result = Objects.requireNonNull((InteractionResult)EventFactory.invokeEventMethod(listener, method, args));
                    if (result == InteractionResult.PASS) continue;
                    return result;
                }
            }
            return InteractionResult.PASS;
        }, typeGetter);
    }

    @SafeVarargs
    public static <T> Event<T> createReturnable(T ... typeGetter) {
        return EventFactory.create(priorityListeners -> (proxy, method, args) -> {
            for (ArrayList listeners : priorityListeners.values()) {
                for (Object listener : listeners) {
                    Object result = EventFactory.invokeEventMethod(listener, method, args);
                    if (result == null) continue;
                    return result;
                }
            }
            return null;
        }, typeGetter);
    }

    @SafeVarargs
    public static <T> Event<T> createLoop(T ... typeGetter) {
        return EventFactory.create(priorityListeners -> (proxy, method, args) -> {
            for (ArrayList listeners : priorityListeners.values()) {
                for (Object listener : listeners) {
                    EventFactory.invokeEventMethod(listener, method, args);
                }
            }
            return null;
        }, typeGetter);
    }

    @SafeVarargs
    public static <T> Event<T> create(Function<Map<Byte, ArrayList<T>>, InvocationHandler> function, T ... typeGetter) {
        if (typeGetter.length != 0) {
            throw new IllegalStateException("Array type getter must be empty!");
        }
        return EventFactory.of(priorityListeners -> Proxy.newProxyInstance(EventFactory.class.getClassLoader(), new Class[]{typeGetter.getClass().getComponentType()}, (InvocationHandler)function.apply((Map)priorityListeners)));
    }

    public static <T> Event<T> of(Function<Map<Byte, ArrayList<T>>, T> function) {
        return new EventImpl<T>(function);
    }

    private static <T, R> R invokeEventMethod(T listener, Method method, Object[] args) throws Throwable {
        return (R)MethodHandles.lookup().unreflect(method).bindTo(listener).invokeWithArguments(args);
    }

    private static class EventImpl<T>
    implements Event<T> {
        private final Function<Map<Byte, ArrayList<T>>, T> function;
        private final Map<Byte, ArrayList<T>> priorityListeners;
        private byte priority;
        private T invoker;

        private EventImpl(Function<Map<Byte, ArrayList<T>>, T> function) {
            this.function = function;
            this.priorityListeners = new ConcurrentHashMap<Byte, ArrayList<T>>();
            this.priority = 0;
            this.invoker = null;
        }

        @Override
        public T invoker() {
            if (this.invoker == null) {
                this.invoker = this.function.apply(this.priorityListeners);
            }
            return this.invoker;
        }

        @Override
        public void register(T listener) {
            this.priorityListeners.computeIfAbsent(this.priority, k -> new ArrayList()).add(listener);
            this.priority = 0;
            this.invoker = null;
        }

        @Override
        public void unregister(T listener) {
            for (ArrayList<T> listeners : this.priorityListeners.values()) {
                listeners.remove(listener);
                listeners.trimToSize();
            }
            this.priorityListeners.entrySet().removeIf(entry -> ((ArrayList)entry.getValue()).isEmpty());
            this.invoker = null;
        }

        @Override
        public void clearListeners() {
            this.priorityListeners.clear();
            this.invoker = null;
        }

        @Override
        public boolean isRegistered(T listener) {
            for (ArrayList<T> listeners : this.priorityListeners.values()) {
                if (!listeners.contains(listener)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Event<T> priority(byte priority) {
            this.priority = priority;
            return this;
        }
    }
}

