/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.hooks;

import java.util.Optional;
import java.util.function.Consumer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;

public final class EventBusHooks {
    private EventBusHooks() {
    }

    public static void ifAvailable(String modId, Consumer<IEventBus> busConsumer) {
        EventBusHooks.ifAvailable(modId, busConsumer, () -> {
            throw new IllegalArgumentException("Mod with the modId: '" + modId + "' is not available!");
        });
    }

    public static void ifAvailable(String modId, Consumer<IEventBus> busConsumer, Runnable fallback) {
        Optional<IEventBus> optionalEventBus = EventBusHooks.getModEventBus(modId);
        if (optionalEventBus.isPresent()) {
            busConsumer.accept(optionalEventBus.get());
        } else {
            fallback.run();
        }
    }

    public static Optional<IEventBus> getModEventBus(String modId) {
        return ModList.get().getModContainerById(modId).map(ModContainer::getEventBus);
    }
}

