/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.mixin.event;

import com.craftjakob.event.events.common.EntityEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.component.BlocksAttacks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Redirect(method={"applyItemBlocking"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/component/BlocksAttacks;resolveBlockedDamage(Lnet/minecraft/world/damagesource/DamageSource;FD)F"))
    private float onApplyItemBlocking(BlocksAttacks instance, DamageSource damageSource, float damageAmount, double horizontalAngle) {
        LivingEntity blocker = (LivingEntity)this;
        final float damage = instance.resolveBlockedDamage(damageSource, damageAmount, horizontalAngle);
        EntityEvent.OnBlock.Context context = new EntityEvent.OnBlock.Context(){
            private float blockedDamage;
            {
                this.blockedDamage = damage;
            }

            @Override
            public float getOriginalDamageAmount() {
                return damage;
            }

            @Override
            public float getBlockedDamage() {
                return this.blockedDamage;
            }

            @Override
            public void setBlockedDamage(float amount) {
                this.blockedDamage = amount;
            }

            @Override
            public boolean isShieldTakingDamage() {
                return this.blockedDamage < 0.0f;
            }
        };
        EntityEvent.ON_BLOCK.invoker().onBlock(blocker, damageSource, blocker.getItemBlockingWith(), context);
        return context.getBlockedDamage();
    }
}

