/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.network;

import com.craftjakob.platform.EnvironmentType;
import com.craftjakob.platform.Platform;
import com.craftjakob.platform.PlatformHelper;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerCommonPacketListener;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public final class PlayNetworking {
    private PlayNetworking() {
    }

    public static void sendToServer(CustomPacketPayload ... payloads) {
        if (Platform.getEnvironment() == EnvironmentType.CLIENT) {
            throw new IllegalArgumentException("Cannot send serverbound packet on the server!");
        }
        if (Platform.isForge()) {
            for (CustomPacketPayload payload : payloads) {
                PlatformHelper.callPlatformMethod(payload);
            }
        }
        ClientPacketListener listener = Objects.requireNonNull(Minecraft.getInstance().getConnection());
        for (CustomPacketPayload payload : payloads) {
            listener.send(PlayNetworking.createC2SPacket(payload));
        }
    }

    public static void sendToPlayer(@NotNull ServerPlayer player, CustomPacketPayload ... payloads) {
        if (Platform.isForge()) {
            PlatformHelper.callPlatformMethod(player, payloads);
        } else {
            player.connection.send(PlayNetworking.createS2CPacket((CustomPacketPayload[])payloads));
        }
    }

    @SafeVarargs
    public static <T extends CustomPacketPayload> Packet<?> createS2CPacket(T ... payloads) {
        if (payloads.length > 1) {
            ArrayList<ClientboundCustomPayloadPacket> packets = new ArrayList<ClientboundCustomPayloadPacket>();
            for (T payload : payloads) {
                packets.add(new ClientboundCustomPayloadPacket(payload));
            }
            return new ClientboundBundlePacket(packets);
        }
        return new ClientboundCustomPayloadPacket(payloads[0]);
    }

    public static <T extends CustomPacketPayload> Packet<ServerCommonPacketListener> createC2SPacket(@NotNull T payload) {
        return new ServerboundCustomPayloadPacket(payload);
    }
}

