/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.platform;

import com.craftjakob.platform.EnvironmentType;
import com.craftjakob.platform.Mod;
import com.craftjakob.platform.ModLoader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.MinecraftServer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;

public final class PlatformImpl {
    private static final Map<String, Mod> MODS = new ConcurrentHashMap<String, Mod>();

    private PlatformImpl() {
    }

    public static EnvironmentType getEnvironment() {
        return FMLLoader.getCurrent().getDist().isClient() ? EnvironmentType.CLIENT : EnvironmentType.SERVER;
    }

    public static Path getGamePath() {
        return FMLPaths.GAMEDIR.get();
    }

    public static Path getModsPath() {
        return FMLPaths.MODSDIR.get();
    }

    public static Path getConfigPath() {
        return FMLPaths.CONFIGDIR.get();
    }

    public static Mod getMod(String modId) {
        return MODS.computeIfAbsent(modId, ModImpl::new);
    }

    public static Map<String, Mod> getMods() {
        for (IModInfo modInfo : ModList.get().getMods()) {
            PlatformImpl.getMod(modInfo.getModId());
        }
        return MODS;
    }

    public static boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static boolean isDevelopmentEnvironment() {
        return !FMLLoader.getCurrent().isProduction();
    }

    public static ModLoader getModLoader() {
        return ModLoader.NEOFORGE;
    }

    public static MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    private static class ModImpl
    implements Mod {
        private final ModContainer container;
        private final IModInfo modInfo;

        public ModImpl(String modId) {
            this.container = (ModContainer)ModList.get().getModContainerById(modId).orElseThrow(() -> new IllegalArgumentException("The given mod id does not exist!"));
            this.modInfo = this.container.getModInfo();
        }

        @Override
        public String getModId() {
            return this.modInfo.getModId();
        }

        @Override
        public String getVersion() {
            return this.modInfo.getVersion().toString();
        }

        @Override
        public String getName() {
            return this.modInfo.getDisplayName();
        }

        @Override
        public String getDescription() {
            return this.modInfo.getDescription();
        }

        @Override
        public Collection<String> getAuthors() {
            Optional<String> optionalAuthors = this.modInfo.getConfig().getConfigElement(new String[]{"authors"}).map(String::valueOf);
            return optionalAuthors.isPresent() ? Collections.singleton(optionalAuthors.get()) : Collections.emptyList();
        }

        @Override
        public Collection<String> getLicense() {
            return Collections.singleton(this.modInfo.getOwningFile().getLicense());
        }

        @Override
        public Optional<String> getLogoFile(int preferredSize) {
            return this.modInfo.getLogoFile();
        }

        @Override
        public Optional<String> getHomePage() {
            return this.modInfo.getConfig().getConfigElement(new String[]{"displayURL"}).map(String::valueOf);
        }

        @Override
        public Optional<String> getIssuesPage() {
            IModFileInfo iModFileInfo = this.modInfo.getOwningFile();
            if (iModFileInfo instanceof ModFileInfo) {
                ModFileInfo info = (ModFileInfo)iModFileInfo;
                return Optional.ofNullable(info.getIssueURL()).map(URL::toString);
            }
            return Optional.empty();
        }

        @Override
        public Optional<String> getSourcesPage() {
            return this.modInfo.getConfig().getConfigElement(new String[]{"sourcesURL"}).map(String::valueOf);
        }

        @Override
        public List<Path> getRootPaths() {
            return List.of(this.modInfo.getOwningFile().getFile().getFilePath());
        }

        @Override
        public Optional<Path> findResource(String filePath) {
            return Optional.of(this.modInfo.getOwningFile().getFile().getFilePath().resolve(filePath)).filter(x$0 -> Files.exists(x$0, new LinkOption[0]));
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void registerConfigScreen(Mod.ConfigScreenProvider provider) {
            this.container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(container, parentScreen) -> provider.createConfigScreen(parentScreen)));
        }
    }
}

