/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registries;

import com.craftjakob.CommonClass;
import com.craftjakob.hooks.EventBusHooks;
import com.craftjakob.registration.registries.RegistryHolder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;

public final class DeferredRegisterImpl {
    private static final List<Data<?>> DATA_TO_REGISTER = new ArrayList();

    private DeferredRegisterImpl() {
    }

    public static <R> RegistryHolder<R> getRegistryHolder(String modId, ResourceKey<? extends Registry<R>> registryKey) {
        EventBusHooks.ifAvailable(modId, bus -> bus.addListener(event -> {
            Iterator<Data<?>> iterator = DATA_TO_REGISTER.iterator();
            while (iterator.hasNext()) {
                Data<?> data = iterator.next();
                if (data.registry().get() == null || !data.registry().get().key().equals(event.getRegistryKey())) continue;
                event.register(data.registry().get().key(), helper -> helper.register(data.id(), data.supplier().get()));
                iterator.remove();
            }
            CommonClass.LOGGER.debug("Registered Objects {} are left to be registered.", (Object)DATA_TO_REGISTER.size());
        }));
        return new RegistryHolder(registryKey);
    }

    public static <T, E extends T> void register(RegistryHolder<T> delegate, Identifier id, Supplier<E> supplier) {
        DATA_TO_REGISTER.add(new Data<T>(delegate, id, supplier));
    }

    public record Data<T>(RegistryHolder<T> registry, Identifier id, Supplier<? extends T> supplier) {
    }
}

