/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registries;

import com.craftjakob.registration.registries.DeferredSupplier;
import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SuppliedHolder<T>
extends DeferredSupplier<T>,
Holder<T> {
    @Nullable
    public Holder<T> getHolder();

    @NotNull
    default public T value() {
        return this.get();
    }

    default public boolean isBound() {
        return this.isPresent();
    }

    default public boolean is(@NotNull Identifier id) {
        return this.getId().equals((Object)id);
    }

    default public boolean is(@NotNull ResourceKey<T> resourceKey) {
        return this.getResourceKey().equals(resourceKey);
    }

    default public boolean is(@NotNull Predicate<ResourceKey<T>> predicate) {
        return predicate.test(this.getResourceKey());
    }

    default public boolean is(@NotNull TagKey<T> tagKey) {
        Holder<T> holder = this.getHolder();
        return holder != null && holder.is(tagKey);
    }

    default public boolean is(@NotNull Holder<T> holder) {
        return holder.is(this.getResourceKey());
    }

    @NotNull
    default public Stream<TagKey<T>> tags() {
        Holder<T> holder = this.getHolder();
        return holder != null ? holder.tags() : Stream.empty();
    }

    @NotNull
    default public Either<ResourceKey<T>, T> unwrap() {
        return Either.left(this.getResourceKey());
    }

    @NotNull
    default public Optional<ResourceKey<T>> unwrapKey() {
        return Optional.of(this.getResourceKey());
    }

    @NotNull
    default public Holder.Kind kind() {
        return Holder.Kind.REFERENCE;
    }

    default public boolean canSerializeIn(@NotNull HolderOwner<T> holderOwner) {
        Holder<T> holder = this.getHolder();
        return holder != null && holder.canSerializeIn(holderOwner);
    }
}

