/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registry;

import com.craftjakob.platform.PlatformHelper;
import com.craftjakob.registration.registries.DeferredSupplier;
import com.craftjakob.registration.registry.CreativeModeTabOutput;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import org.jetbrains.annotations.Nullable;

public final class CreativeModeTabRegistry {
    private CreativeModeTabRegistry() {
    }

    public static void modify(DeferredSupplier<CreativeModeTab> deferredTab, ModifyTabCallback callback) {
        PlatformHelper.callPlatformMethod(deferredTab, callback);
    }

    public static void modify(ResourceKey<CreativeModeTab> tabKey, ModifyTabCallback callback) {
        CreativeModeTabRegistry.modify(CreativeModeTabRegistry.deferTab(tabKey.identifier()), callback);
    }

    public static void modify(CreativeModeTab tab, ModifyTabCallback callback) {
        Identifier key = BuiltInRegistries.CREATIVE_MODE_TAB.getKey((Object)tab);
        if (key == null) {
            throw new IllegalStateException("Cannot create DeferredSupplier for non- or not created registries tab: " + String.valueOf(tab));
        }
        CreativeModeTabRegistry.modify(CreativeModeTabRegistry.deferTab(key), callback);
    }

    public static DeferredSupplier<CreativeModeTab> deferTab(final Identifier id) {
        return new DeferredSupplier<CreativeModeTab>(){
            @Nullable
            private CreativeModeTab tab;

            @Override
            public Identifier getId() {
                return id;
            }

            @Override
            public Identifier getRegistryId() {
                return Registries.CREATIVE_MODE_TAB.identifier();
            }

            @Override
            public boolean isPresent() {
                this.resolve();
                return this.tab != null;
            }

            @Override
            public CreativeModeTab get() {
                this.resolve();
                if (this.tab == null) {
                    throw new IllegalStateException("Creative tab " + String.valueOf(id) + " is not registered yet!");
                }
                return this.tab;
            }

            private void resolve() {
                if (this.tab == null) {
                    this.tab = (CreativeModeTab)BuiltInRegistries.CREATIVE_MODE_TAB.getValue(id);
                }
            }
        };
    }

    @FunctionalInterface
    public static interface ModifyTabCallback {
        public void accept(CreativeModeTab.ItemDisplayParameters var1, CreativeModeTabOutput var2, boolean var3);
    }
}

