/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registry;

import com.google.common.eventbus.Subscribe;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.FuelValues;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.furnace.FurnaceFuelBurnTimeEvent;
import org.jetbrains.annotations.Nullable;

public final class FuelRegistryImpl {
    private static final Map<ItemLike, Integer> ITEMS = new HashMap<ItemLike, Integer>();

    private FuelRegistryImpl() {
    }

    public static void register(int burnTime, ItemLike ... itemLikes) {
        for (ItemLike itemLike : itemLikes) {
            ITEMS.put(itemLike, burnTime);
        }
    }

    public static int get(ItemStack stack, @Nullable RecipeType<?> recipeType, FuelValues fuelValues) {
        return stack.getBurnTime(recipeType, fuelValues);
    }

    @Subscribe
    public static void event(FurnaceFuelBurnTimeEvent event) {
        int time;
        if (!event.getItemStack().isEmpty() && (time = ITEMS.getOrDefault(event.getItemStack().getItem(), Integer.MIN_VALUE).intValue()) != Integer.MIN_VALUE) {
            event.setBurnTime(time);
        }
    }

    static {
        NeoForge.EVENT_BUS.register(FuelRegistryImpl.class);
    }
}

