/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registry;

import com.craftjakob.hooks.EventBusHooks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.DefaultedMappedRegistry;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.registries.RegistryBuilder;

public final class RegistryBuilderImpl {
    private static final List<Registry<?>> CUSTOM_REGISTRIES = new ArrayList();

    private RegistryBuilderImpl() {
    }

    public static <T> MappedRegistry<T> create(ResourceKey<Registry<T>> registryKey, boolean synced) {
        MappedRegistry registry = (MappedRegistry)new RegistryBuilder(registryKey).sync(synced).create();
        CUSTOM_REGISTRIES.add((Registry<?>)registry);
        return registry;
    }

    public static <T> DefaultedMappedRegistry<T> createDefaulted(ResourceKey<Registry<T>> registryKey, Identifier defaultId, boolean synced) {
        DefaultedMappedRegistry registry = (DefaultedMappedRegistry)new RegistryBuilder(registryKey).defaultKey(defaultId).sync(synced).create();
        CUSTOM_REGISTRIES.add((Registry<?>)registry);
        return registry;
    }

    static {
        EventBusHooks.ifAvailable("configapi", bus -> bus.addListener(EventPriority.HIGHEST, event -> {
            for (Registry<?> registry : CUSTOM_REGISTRIES) {
                event.register(registry);
            }
        }));
    }
}

