/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registry;

import com.craftjakob.platform.PlatformHelper;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import org.jetbrains.annotations.Nullable;

public final class RegistryRegistry {
    private static final Map<ResourceKey<? extends Registry<?>>, Registry<?>> CACHED_CUSTOM_REGISTRIES = new HashMap();

    private RegistryRegistry() {
    }

    public static <T> void registerRegistry(Registry<? extends T> registry) {
        CACHED_CUSTOM_REGISTRIES.put(registry.key(), registry);
    }

    public static Iterable<? extends Registry<?>> getRegistries() {
        return BuiltInRegistries.REGISTRY;
    }

    public static <T> Registry<T> getRegistry(ResourceKey<? extends Registry<T>> key) {
        Registry registry = (Registry)BuiltInRegistries.REGISTRY.getValue(key.identifier());
        if (registry == null) {
            throw new IllegalArgumentException("Registry " + String.valueOf(key) + " not found");
        }
        return registry;
    }

    public static <T> Registry<T> getRegistryOrCachedRegistry(ResourceKey<Registry<T>> registryKey) {
        if (BuiltInRegistries.REGISTRY.containsKey(registryKey.identifier())) {
            return (Registry)BuiltInRegistries.REGISTRY.getValue(registryKey.identifier());
        }
        if (CACHED_CUSTOM_REGISTRIES.containsKey(registryKey)) {
            return CACHED_CUSTOM_REGISTRIES.get(registryKey);
        }
        throw new IllegalArgumentException("Registry " + String.valueOf(registryKey) + " does not exist! Register your custom Registries via Registry.Registry.registerRegistry(...).");
    }

    public static <T> void registerDataPack(ResourceKey<Registry<T>> registryKey, Codec<T> codec) {
        RegistryRegistry.registerDataPack(registryKey, codec, null);
    }

    public static <T> void registerDataPack(ResourceKey<Registry<T>> registryKey, Codec<T> codec, @Nullable Codec<T> networkCodec) {
        PlatformHelper.callPlatformMethod(registryKey, codec, networkCodec);
    }
}

