/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registry;

import com.craftjakob.hooks.EventBusHooks;
import com.craftjakob.platform.EnvironmentType;
import com.craftjakob.platform.Platform;
import com.craftjakob.platform.annotation.Environment;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.neoforge.client.event.AddClientReloadListenersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddServerReloadListenersEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReloadListenerRegistryImpl {
    private static final Map<Identifier, Pair<PreparableReloadListener, @Nullable Collection<Identifier>>> CLIENT_RELOAD_LISTENERS = new HashMap<Identifier, Pair<PreparableReloadListener, Collection<Identifier>>>();
    private static final Map<Identifier, Pair<Function<// Could not load outer class - annotation placement on inner may be incorrect
    HolderLookup.Provider, PreparableReloadListener>, @Nullable Collection<Identifier>>> SERVER_DATA_RELOAD_LISTENERS = new HashMap<Identifier, Pair<Function<HolderLookup.Provider, PreparableReloadListener>, Collection<Identifier>>>();

    private ReloadListenerRegistryImpl() {
    }

    @Environment(value=EnvironmentType.CLIENT)
    public static void registerClient(@NotNull Identifier listenerId, PreparableReloadListener listener, @Nullable Collection<Identifier> dependencies) {
        CLIENT_RELOAD_LISTENERS.put(listenerId, (Pair<PreparableReloadListener, Collection<Identifier>>)Pair.of((Object)listener, dependencies));
    }

    @Environment(value=EnvironmentType.SERVER)
    public static void registerServer(@NotNull Identifier listenerId, Function<HolderLookup.Provider, PreparableReloadListener> listenerFunction, @Nullable Collection<Identifier> dependencies) {
        SERVER_DATA_RELOAD_LISTENERS.put(listenerId, (Pair<Function<HolderLookup.Provider, PreparableReloadListener>, Collection<Identifier>>)Pair.of(listenerFunction, dependencies));
    }

    public static void addClientReloadListeners(AddClientReloadListenersEvent event) {
        for (Map.Entry<Identifier, Pair<PreparableReloadListener, Collection<Identifier>>> entry : CLIENT_RELOAD_LISTENERS.entrySet()) {
            PreparableReloadListener listener = (PreparableReloadListener)entry.getValue().getFirst();
            @Nullable Collection dependencies = (Collection)entry.getValue().getSecond();
            event.addListener(entry.getKey(), listener);
            if (dependencies == null) continue;
            dependencies.forEach(dependency -> event.addDependency((Identifier)entry.getKey(), dependency));
        }
    }

    public static void addServerReloadListeners(AddServerReloadListenersEvent event) {
        for (Map.Entry<Identifier, Pair<Function<HolderLookup.Provider, PreparableReloadListener>, Collection<Identifier>>> entry : SERVER_DATA_RELOAD_LISTENERS.entrySet()) {
            Function listenerFunction = (Function)entry.getValue().getFirst();
            @Nullable Collection dependencies = (Collection)entry.getValue().getSecond();
            event.addListener(entry.getKey(), (PreparableReloadListener)listenerFunction.apply(event.getRegistryAccess()));
            if (dependencies == null) continue;
            dependencies.forEach(dependency -> event.addDependency((Identifier)entry.getKey(), dependency));
        }
    }

    static {
        EventBusHooks.ifAvailable("configapi", bus -> {
            if (Platform.getEnvironment() == EnvironmentType.CLIENT) {
                bus.addListener(ReloadListenerRegistryImpl::addClientReloadListeners);
            }
        });
        NeoForge.EVENT_BUS.addListener(ReloadListenerRegistryImpl::addServerReloadListeners);
    }
}

