/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registry.client;

import com.craftjakob.hooks.EventBusHooks;
import com.craftjakob.registration.registry.client.ParticleProviderRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.RandomSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.NonNull;

@OnlyIn(value=Dist.CLIENT)
public final class ParticleProviderRegistryImpl {
    private static final Map<ParticleType<?>, ParticleProvider<?>> PARTICLE_PROVIDERS = new HashMap();
    private static final Map<ParticleType<?>, ParticleProviderRegistry.ParticleFactory<?>> PARTICLE_FACTORIES = new HashMap();

    private ParticleProviderRegistryImpl() {
    }

    public <T extends ParticleOptions> void register(ParticleType<T> type, ParticleProvider<T> provider) {
        PARTICLE_PROVIDERS.put(type, provider);
    }

    public <T extends ParticleOptions> void registerSpriteSet(ParticleType<T> type, ParticleProviderRegistry.ParticleFactory<T> factory) {
        PARTICLE_FACTORIES.put(type, factory);
    }

    static {
        EventBusHooks.ifAvailable("configapi", bus -> bus.addListener(event -> {
            ParticleType<?> type;
            for (Map.Entry<ParticleType<?>, ParticleProvider<?>> entry : PARTICLE_PROVIDERS.entrySet()) {
                type = entry.getKey();
                ParticleProvider<?> provider = entry.getValue();
                event.registerSpecial(type, provider);
            }
            for (Map.Entry<ParticleType<?>, Object> entry : PARTICLE_FACTORIES.entrySet()) {
                type = entry.getKey();
                ParticleProviderRegistry.ParticleFactory factory = (ParticleProviderRegistry.ParticleFactory)entry.getValue();
                event.registerSpriteSet(type, spriteSet -> factory.create(new SpriteSet(){

                    @NotNull
                    public TextureAtlasSprite get(int age, int lifetime) {
                        return spriteSet.get(age, lifetime);
                    }

                    @NotNull
                    public TextureAtlasSprite get(@NotNull RandomSource random) {
                        return spriteSet.get(random);
                    }

                    public @NonNull TextureAtlasSprite first() {
                        return spriteSet.first();
                    }
                }));
            }
        }));
    }
}

