/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registry.client;

import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class RenderRegistryImpl {
    private RenderRegistryImpl() {
    }

    public static void setRenderType(ChunkSectionLayer layer, Block ... blocks) {
        for (Block block : blocks) {
            ItemBlockRenderTypes.setRenderLayer((Block)block, (ChunkSectionLayer)layer);
        }
    }

    public static void setRenderType(ChunkSectionLayer layer, Fluid ... fluids) {
        for (Fluid fluid : fluids) {
            ItemBlockRenderTypes.setRenderLayer((Fluid)fluid, (ChunkSectionLayer)layer);
        }
    }

    public static <T extends Entity> void registerEntityRenderer(EntityType<? extends T> type, EntityRendererProvider<? super T> provider) {
        EntityRenderers.register(type, provider);
    }

    public static <T extends BlockEntity, S extends BlockEntityRenderState> void registerBlockEntityRenderer(BlockEntityType<? extends T> type, BlockEntityRendererProvider<? super T, ? super S> provider) {
        BlockEntityRenderers.register(type, provider);
    }
}

