/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registry.level;

import com.craftjakob.platform.PlatformHelper;
import java.util.Optional;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.villager.VillagerProfession;
import net.minecraft.world.entity.npc.villager.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import org.jspecify.annotations.NonNull;

public final class TradeRegistry {
    private TradeRegistry() {
    }

    public static void registerVillagerTrade(ResourceKey<VillagerProfession> professionKey, int level, VillagerTrades.ItemListing ... trades) {
        if (level < 1) {
            throw new IllegalArgumentException("Villager Trade level has to be at least 1!");
        }
        PlatformHelper.callPlatformMethod(professionKey, level, trades);
    }

    public static void registerTradeForWanderingTrader(WandererTradeType type, VillagerTrades.ItemListing ... trades) {
        PlatformHelper.callPlatformMethod(new Object[]{type, trades});
    }

    public static enum WandererTradeType {
        BUYING_TRADES,
        COMMON_TRADES,
        SPECIAL_TRADES;

    }

    public record SimpleTrade(ItemCost primaryPrice, Optional<ItemCost> secondaryPrice, ItemStack sale, int maxTrades, int experiencePoints, float priceMultiplier) implements VillagerTrades.ItemListing
    {
        public @NonNull MerchantOffer getOffer(@NonNull ServerLevel serverLevel, @NonNull Entity entity, @NonNull RandomSource randomSource) {
            return new MerchantOffer(this.primaryPrice, this.secondaryPrice, this.sale, this.maxTrades, this.experiencePoints, this.priceMultiplier);
        }
    }
}

