/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registry.level.biome;

import com.craftjakob.hooks.level.biome.BiomeSettings;
import com.craftjakob.platform.PlatformHelper;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.LevelStem;

public final class BiomeModificationRegistry {
    private BiomeModificationRegistry() {
    }

    public static void addProperties(BiConsumer<BiomeContext, BiomeSettings.Mutable> modifier) {
        BiomeModificationRegistry.putModification(ModificationPhase.ADD, modifier);
    }

    public static void removeProperties(BiConsumer<BiomeContext, BiomeSettings.Mutable> modifier) {
        BiomeModificationRegistry.putModification(ModificationPhase.REMOVE, modifier);
    }

    public static void replaceProperties(BiConsumer<BiomeContext, BiomeSettings.Mutable> modifier) {
        BiomeModificationRegistry.putModification(ModificationPhase.REPLACE, modifier);
    }

    public static void postProcessProperties(BiConsumer<BiomeContext, BiomeSettings.Mutable> modifier) {
        BiomeModificationRegistry.putModification(ModificationPhase.POST_PROCESS, modifier);
    }

    public static void putModification(ModificationPhase phase, BiConsumer<BiomeContext, BiomeSettings.Mutable> modifier) {
        PlatformHelper.callPlatformMethod(new Object[]{phase, modifier});
    }

    public static enum ModificationPhase {
        ADD,
        REMOVE,
        REPLACE,
        POST_PROCESS;

    }

    public static interface BiomeContext {
        public Biome getBiome();

        public Holder<Biome> getBiomeHolder();

        public ResourceKey<Biome> getBiomeKey();

        public BiomeSettings getBiomeSettings();

        public boolean hasTag(TagKey<Biome> var1);

        public boolean canGenerateIn(ResourceKey<LevelStem> var1);
    }
}

