/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registry.level.biome;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
final class BiomeRegistry {
    private static final Map<ResourceKey<Level>, Map<ResourceKey<Biome>, Double>> ADDED_BIOMES = new HashMap<ResourceKey<Level>, Map<ResourceKey<Biome>, Double>>();

    private BiomeRegistry() {
    }

    public static void addBiome(ResourceKey<Level> dimensionKey, ResourceKey<Biome> biomeKey, double weight) {
        ADDED_BIOMES.computeIfAbsent(dimensionKey, k -> new HashMap()).put(biomeKey, weight);
    }

    public static void applyBiomes(MinecraftServer server) {
        RegistryAccess.Frozen registryAccess = server.registryAccess();
        Registry biomeRegistry = registryAccess.lookupOrThrow(Registries.BIOME);
        long seed = server.getWorldData().worldGenOptions().seed();
        ADDED_BIOMES.forEach((levelKey, biomeMap) -> {
            ServerLevel serverLevel = server.getLevel(levelKey);
            if (serverLevel != null) {
                ChunkGenerator chunkGenerator = serverLevel.getChunkSource().getGenerator();
                BiomeSource biomeSource = chunkGenerator.getBiomeSource();
                biomeMap.forEach((biomeKey, weight) -> {
                    HashSet<Holder.Reference> moddedPossibleBiomes = new HashSet<Holder.Reference>(biomeSource.possibleBiomes());
                    moddedPossibleBiomes.add(biomeRegistry.getOrThrow(biomeKey));
                });
            }
        });
    }
}

