/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registry.level.biome;

import com.craftjakob.mixin.accessor.NoiseGeneratorSettingsAccess;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.jetbrains.annotations.ApiStatus;

public final class SurfaceRuleModifierRegistry {
    private static final Map<ResourceKey<Level>, SurfaceRules.RuleSource> SURFACE_RULES = new HashMap<ResourceKey<Level>, SurfaceRules.RuleSource>();

    private SurfaceRuleModifierRegistry() {
    }

    public static void addSurfaceRuleToExisting(ResourceKey<Level> dimensionLevel, SurfaceRules.RuleSource ruleSource) {
        SURFACE_RULES.put(dimensionLevel, ruleSource);
    }

    @ApiStatus.Internal
    public static void applySurfaceRule(MinecraftServer server) {
        SURFACE_RULES.forEach((levelResourceKey, ruleSource) -> {
            ChunkGenerator chunkGenerator;
            ServerLevel serverLevel = server.getLevel(levelResourceKey);
            if (serverLevel != null && (chunkGenerator = serverLevel.getChunkSource().getGenerator()) instanceof NoiseBasedChunkGenerator) {
                NoiseBasedChunkGenerator noiseBasedChunkGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
                NoiseGeneratorSettings settings = (NoiseGeneratorSettings)noiseBasedChunkGenerator.generatorSettings().value();
                ((NoiseGeneratorSettingsAccess)settings).setSurfaceRule(SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{ruleSource, settings.surfaceRule()}));
            }
        });
    }
}

