/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registry.menu;

import com.craftjakob.hooks.EventBusHooks;
import com.craftjakob.registration.registry.menu.ExtendedMenuProvider;
import com.craftjakob.registration.registry.menu.MenuRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;

public final class MenuRegistryImpl {
    private static final List<ScreenConstructor<?, ?>> SCREENS = new ArrayList();

    private MenuRegistryImpl() {
    }

    public static void openExtendedMenu(ServerPlayer player, ExtendedMenuProvider provider) {
        player.openMenu((MenuProvider)provider, provider::saveExtraData);
    }

    public static <T extends AbstractContainerMenu> MenuType<T> of(MenuRegistry.ExtendedMenuTypeFactory<T> factory) {
        return IMenuTypeExtension.create(factory::create);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <M extends AbstractContainerMenu, S extends Screen> void registerScreenFactory(Supplier<MenuType<? extends M>> type, MenuRegistry.ScreenFactory<M, S> factory) {
        SCREENS.add(new ScreenConstructor<M, S>(type, factory));
    }

    private static <M extends AbstractContainerMenu, S extends Screen> void registerScreen(RegisterMenuScreensEvent event, ScreenConstructor<?, ?> rawConstructor) {
        ScreenConstructor<?, ?> constructor = rawConstructor;
        MenuType<?> type = constructor.type().get();
        MenuRegistry.ScreenFactory<?, ?> factory = constructor.factory();
        event.register(type, factory::create);
    }

    static {
        EventBusHooks.ifAvailable("configapi", bus -> bus.addListener(event -> {
            for (ScreenConstructor<?, ?> constructor : SCREENS) {
                MenuRegistryImpl.registerScreen(event, constructor);
            }
        }));
    }

    record ScreenConstructor<M extends AbstractContainerMenu, S extends Screen>(Supplier<MenuType<? extends M>> type, MenuRegistry.ScreenFactory<M, S> factory) {
    }
}

