/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.entityculling.mixin;

import dev.tr7zw.entityculling.EntityCullingModBase;
import dev.tr7zw.entityculling.NMSCullingHelper;
import dev.tr7zw.entityculling.mixin.LivingEntityRendererAccessor;
import dev.tr7zw.entityculling.versionless.access.Cullable;
import dev.tr7zw.transition.mc.GeneralUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.ClientAvatarEntity;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.state.LevelRenderState;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelRenderer.class})
public class WorldRendererMixin {
    private EntityRenderDispatcher entityCulling$entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
    private List<Runnable> lateRenders = new ArrayList<Runnable>();
    private double aabbExpansion = 0.5;

    @Inject(at={@At(value="HEAD")}, method={"extractEntity(Lnet/minecraft/world/entity/Entity;F)Lnet/minecraft/client/renderer/entity/state/EntityRenderState;"}, cancellable=true)
    private void extractEntityRedir(Entity entity, float partialTick, CallbackInfoReturnable<EntityRenderState> ci) {
        if (EntityCullingModBase.instance.config.skipEntityCulling) {
            return;
        }
        Cullable cullable = (Cullable)entity;
        if (!cullable.isForcedVisible() && cullable.isCulled() && !NMSCullingHelper.ignoresCulling(entity)) {
            ++EntityCullingModBase.instance.skippedEntities;
            EntityRenderState state = new EntityRenderState();
            state.entityType = EntityType.INTERACTION;
            if (EntityCullingModBase.instance.config.renderNametagsThroughWalls && entity.shouldShowName()) {
                if (entity instanceof LivingEntity) {
                    LivingEntityRendererAccessor accessor;
                    LivingEntity living = (LivingEntity)entity;
                    EntityRenderer renderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)living);
                    double d = GeneralUtil.getCameraEntity().distanceToSqr(entity);
                    if (renderer instanceof LivingEntityRendererAccessor && (accessor = (LivingEntityRendererAccessor)renderer).invokeShouldShowName(living, d)) {
                        if (entity instanceof ClientAvatarEntity) {
                            Component display;
                            ClientAvatarEntity avatar = (ClientAvatarEntity)entity;
                            if (d < 100.0 && (display = avatar.belowNameDisplay()) != null) {
                                AvatarRenderState avatarState = new AvatarRenderState();
                                avatarState.entityType = EntityType.PLAYER;
                                avatarState.scoreText = display;
                                avatarState.isInvisibleToPlayer = true;
                                state = avatarState;
                            }
                        }
                        state.nameTag = entity.getDisplayName();
                        state.nameTagAttachment = entity.getAttachments().getNullable(EntityAttachment.NAME_TAG, 0, entity.getYRot(partialTick));
                    }
                } else {
                    state.nameTag = entity.getDisplayName();
                    state.nameTagAttachment = entity.getAttachments().getNullable(EntityAttachment.NAME_TAG, 0, entity.getYRot(partialTick));
                }
            }
            state.x = Mth.lerp((double)partialTick, (double)entity.xOld, (double)entity.getX());
            state.y = Mth.lerp((double)partialTick, (double)entity.yOld, (double)entity.getY());
            state.z = Mth.lerp((double)partialTick, (double)entity.zOld, (double)entity.getZ());
            state.isInvisible = true;
            ci.setReturnValue((Object)state);
            return;
        }
        ++EntityCullingModBase.instance.renderedEntities;
        cullable.setOutOfCamera(false);
    }

    @Inject(at={@At(value="HEAD")}, method={"extractVisibleEntities(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/culling/Frustum;Lnet/minecraft/client/DeltaTracker;Lnet/minecraft/client/renderer/state/LevelRenderState;)V"})
    private void extractVisibleEntities(Camera camera, Frustum frustum, DeltaTracker deltaTracker, LevelRenderState levelRenderState, CallbackInfo ci) {
        EntityCullingModBase.instance.frustum = frustum;
    }
}

