/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.client.model;

import fuzs.eternalnether.client.renderer.entity.state.WexRenderState;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.model.monster.skeleton.SkeletonModel;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.util.Mth;

public class WexModel
extends HumanoidModel<WexRenderState> {
    private final ModelPart leftWing;
    private final ModelPart rightWing;

    public WexModel(ModelPart part) {
        super(part);
        this.rightWing = part.getChild("right_wing");
        this.leftWing = part.getChild("left_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = SkeletonModel.createBodyLayer().mesh;
        WexModel.modifyMesh(meshDefinition);
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    private static void modifyMesh(MeshDefinition meshDefinition) {
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.clearChild("right_leg");
        partDefinition.clearChild("left_leg");
        partDefinition.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(0, 32).addBox(-20.0f, 0.0f, 0.0f, 20.0f, 12.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)2.0f, (float)0.47123894f, (float)0.47123894f, (float)0.47123894f));
        partDefinition.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(0, 32).mirror().addBox(0.0f, 0.0f, 0.0f, 20.0f, 12.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)2.0f, (float)0.47123894f, (float)-0.47123894f, (float)-0.47123894f));
    }

    public void setupAnim(WexRenderState renderState) {
        super.setupAnim((HumanoidRenderState)renderState);
        if (renderState.isCharging) {
            if (renderState.getMainHandItemState().isEmpty()) {
                this.rightArm.xRot = 4.712389f;
                this.leftArm.xRot = 4.712389f;
            } else {
                if (!renderState.rightHandItemState.isEmpty()) {
                    this.rightArm.xRot = 3.7699115f;
                }
                if (!renderState.leftHandItemState.isEmpty()) {
                    this.leftArm.xRot = 3.7699115f;
                }
            }
        }
        float flapAmount = Mth.cos((double)(renderState.ageInTicks * 45.836624f * ((float)Math.PI / 180))) * (float)Math.PI * 0.05f;
        this.rightWing.yRot += flapAmount;
        this.leftWing.yRot -= flapAmount;
    }
}

