/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.client.renderer.entity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import fuzs.eternalnether.EternalNether;
import fuzs.eternalnether.client.model.geom.ModModelLayers;
import fuzs.eternalnether.client.renderer.entity.state.WarpedEndermanRenderState;
import fuzs.eternalnether.world.entity.monster.WarpedEnderman;
import java.util.Map;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.model.monster.enderman.EndermanModel;
import net.minecraft.client.renderer.entity.EndermanRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EndermanRenderState;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.monster.EnderMan;

public class WarpedEndermanRenderer
extends EndermanRenderer {
    private static final Map<WarpedEnderman.Variant, Identifier> TEXTURE_LOCATIONS = Maps.immutableEnumMap((Map)ImmutableMap.of((Object)((Object)WarpedEnderman.Variant.FRESH), (Object)EternalNether.id("textures/entity/enderman/warped_enderman_fresh.png"), (Object)((Object)WarpedEnderman.Variant.SHORT_VINE), (Object)EternalNether.id("textures/entity/enderman/warped_enderman_short_vine.png"), (Object)((Object)WarpedEnderman.Variant.LONG_VINE), (Object)EternalNether.id("textures/entity/enderman/warped_enderman_long_vine.png")));

    public WarpedEndermanRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new EndermanModel(context.bakeLayer(ModModelLayers.WARPED_ENDERMAN));
    }

    public static LayerDefinition createBodyLayer() {
        return EndermanModel.createBodyLayer().apply(meshDefinition -> {
            WarpedEndermanRenderer.modifyMesh(meshDefinition);
            return meshDefinition;
        });
    }

    private static void modifyMesh(MeshDefinition meshDefinition) {
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.getChild("head").addOrReplaceChild("stem_body", CubeListBuilder.create().texOffs(44, 0).mirror().addBox(-10.0f, -18.0f, 0.0f, 6.0f, 16.0f, 0.0f), PartPose.ZERO);
        partDefinition.getChild("left_arm").addOrReplaceChild("stem_arm", CubeListBuilder.create().texOffs(32, 0).addBox(1.0f, -1.0f, 0.0f, 6.0f, 16.0f, 0.0f), PartPose.ZERO);
    }

    public EndermanRenderState createRenderState() {
        return new WarpedEndermanRenderState();
    }

    public void extractRenderState(EnderMan enderMan, EndermanRenderState endermanRenderState, float partialTick) {
        super.extractRenderState(enderMan, endermanRenderState, partialTick);
        ((WarpedEndermanRenderState)endermanRenderState).variant = ((WarpedEnderman)enderMan).getVariant();
    }

    public Identifier getTextureLocation(EndermanRenderState renderState) {
        return TEXTURE_LOCATIONS.get((Object)((WarpedEndermanRenderState)renderState).variant);
    }
}

