/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.client.renderer.entity;

import fuzs.eternalnether.EternalNether;
import fuzs.eternalnether.client.model.WexModel;
import fuzs.eternalnether.client.model.geom.ModModelLayers;
import fuzs.eternalnether.client.renderer.entity.state.WexRenderState;
import fuzs.eternalnether.world.entity.monster.Wex;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.Mob;

public class WexRenderer
extends HumanoidMobRenderer<Wex, WexRenderState, WexModel> {
    private static final Identifier TEXTURE_LOCATION = EternalNether.id("textures/entity/skeleton/wex.png");
    private static final Identifier CHARGING_TEXTURE_LOCATION = EternalNether.id("textures/entity/skeleton/wex_charging.png");

    public WexRenderer(EntityRendererProvider.Context context) {
        super(context, (HumanoidModel)new WexModel(context.bakeLayer(ModModelLayers.WEX)), 0.3f);
    }

    protected int getBlockLightLevel(Wex wex, BlockPos blockPos) {
        return 15;
    }

    public WexRenderState createRenderState() {
        return new WexRenderState();
    }

    public void extractRenderState(Wex wex, WexRenderState renderState, float partialTick) {
        super.extractRenderState((Mob)wex, (HumanoidRenderState)renderState, partialTick);
        renderState.isCharging = wex.isCharging();
    }

    public Identifier getTextureLocation(WexRenderState renderState) {
        return renderState.isCharging ? CHARGING_TEXTURE_LOCATION : TEXTURE_LOCATION;
    }
}

