/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.world.entity.ai.goal;

import fuzs.eternalnether.world.entity.ai.goal.OwnableEntityHelper;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.PathType;
import org.jspecify.annotations.Nullable;

public class FollowOwnerGoal<T extends PathfinderMob>
extends Goal {
    private final T tamable;
    private @Nullable LivingEntity owner;
    private final double speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;
    private float oldWaterCost;

    public FollowOwnerGoal(T tamable, double speedModifier, float startDistance, float stopDistance) {
        this.tamable = tamable;
        this.speedModifier = speedModifier;
        this.navigation = tamable.getNavigation();
        this.startDistance = startDistance;
        this.stopDistance = stopDistance;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(tamable.getNavigation() instanceof GroundPathNavigation) && !(tamable.getNavigation() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean canUse() {
        LivingEntity livingEntity = ((OwnableEntity)this.tamable).getOwner();
        if (livingEntity == null) {
            return false;
        }
        if (OwnableEntityHelper.unableToMoveToOwner(this.tamable)) {
            return false;
        }
        if (this.tamable.distanceToSqr((Entity)livingEntity) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = livingEntity;
        return true;
    }

    public boolean canContinueToUse() {
        if (this.navigation.isDone()) {
            return false;
        }
        return !OwnableEntityHelper.unableToMoveToOwner(this.tamable) && !(this.tamable.distanceToSqr((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    public void start() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.tamable.getPathfindingMalus(PathType.WATER);
        this.tamable.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public void stop() {
        this.owner = null;
        this.navigation.stop();
        this.tamable.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
    }

    public void tick() {
        boolean bl = OwnableEntityHelper.shouldTryTeleportToOwner(this.tamable);
        if (!bl) {
            this.tamable.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.tamable.getMaxHeadXRot());
        }
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.adjustedTickDelay(10);
            if (bl) {
                OwnableEntityHelper.tryToTeleportToOwner(this.tamable);
            } else {
                this.navigation.moveTo((Entity)this.owner, this.speedModifier);
            }
        }
    }
}

