/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.world.entity.ai.goal;

import fuzs.eternalnether.world.entity.monster.ShieldedMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;

public class ShieldDefenseGoal<M extends Mob, T extends LivingEntity>
extends NearestAttackableTargetGoal<T> {
    private final M mob;
    private int shieldCooldownPeriod;
    private int shieldWarmupPeriod;

    public ShieldDefenseGoal(M mob, Class<T> targetType) {
        super(mob, targetType, true);
        this.mob = mob;
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse() && !((ShieldedMob)this.mob).isShieldDisabled() && this.shieldCooldownPeriod > 0;
    }

    public void start() {
        super.start();
        this.shieldWarmupPeriod = this.adjustedTickDelay(3 + this.mob.getRandom().nextInt(3));
        this.shieldCooldownPeriod = this.adjustedTickDelay(15 + this.mob.getRandom().nextInt(25));
    }

    public void stop() {
        super.stop();
        ((ShieldedMob)this.mob).stopUsingShield();
    }

    public void tick() {
        if (this.target != null && ShieldDefenseGoal.isUsingNonMeleeWeapon(this.target)) {
            if (this.shieldWarmupPeriod > 0) {
                --this.shieldWarmupPeriod;
            } else {
                this.mob.getLookControl().setLookAt(this.target.getX(), this.target.getEyeY(), this.target.getZ(), 10.0f, (float)this.mob.getMaxHeadXRot());
                ((ShieldedMob)this.mob).startUsingShield();
            }
        } else if (this.shieldCooldownPeriod > 0) {
            --this.shieldCooldownPeriod;
        }
    }

    protected void findTarget() {
        super.findTarget();
        if (this.target != null && !ShieldDefenseGoal.isUsingNonMeleeWeapon(this.target)) {
            this.target = null;
        }
    }

    private static boolean isUsingNonMeleeWeapon(LivingEntity livingEntity) {
        return livingEntity.isHolding(itemStack -> {
            Mob mob;
            return !(!livingEntity.isUsingItem() && !CrossbowItem.isCharged((ItemStack)itemStack) || livingEntity instanceof Mob && !(mob = (Mob)livingEntity).canUseNonMeleeWeapon(itemStack));
        });
    }
}

