/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.world.entity.monster.piglin;

import fuzs.eternalnether.init.ModTags;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.monster.piglin.PiglinBruteAi;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.trim.ArmorTrim;

public class ModPiglinBruteAi
extends PiglinBruteAi {
    public static Optional<? extends LivingEntity> findNearestValidAttackTarget(ServerLevel serverLevel, AbstractPiglin abstractPiglin) {
        Optional optional2;
        Brain brain = abstractPiglin.getBrain();
        Optional optional = BehaviorUtils.getLivingEntityFromUUIDMemory((LivingEntity)abstractPiglin, (MemoryModuleType)MemoryModuleType.ANGRY_AT);
        if (optional.isPresent() && Sensor.isEntityAttackableIgnoringLineOfSight((ServerLevel)serverLevel, (LivingEntity)abstractPiglin, (LivingEntity)((LivingEntity)optional.get()))) {
            return optional;
        }
        if (brain.hasMemoryValue(MemoryModuleType.UNIVERSAL_ANGER) && (optional2 = brain.getMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER)).isPresent()) {
            return optional2;
        }
        optional2 = brain.getMemory(MemoryModuleType.NEAREST_VISIBLE_NEMESIS);
        if (optional2.isPresent()) {
            return optional2;
        }
        Optional optional3 = brain.getMemory(MemoryModuleType.NEAREST_TARGETABLE_PLAYER_NOT_WEARING_GOLD);
        return optional3.isPresent() && Sensor.isEntityAttackable((ServerLevel)serverLevel, (LivingEntity)abstractPiglin, (LivingEntity)((LivingEntity)optional3.get())) ? optional3 : Optional.empty();
    }

    public static void setAngerTargetToNearestTargetablePlayerIfFound(PiglinBrute piglinBrute, LivingEntity defaultEntity) {
        Optional optional = piglinBrute.getBrain().hasMemoryValue(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER) ? piglinBrute.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER) : Optional.empty();
        PiglinBruteAi.setAngerTarget((PiglinBrute)piglinBrute, (LivingEntity)(optional.isPresent() ? (LivingEntity)optional.get() : defaultEntity));
    }

    public static boolean isWearingSafeArmor(LivingEntity livingEntity) {
        for (EquipmentSlot equipmentSlot : EquipmentSlotGroup.ARMOR) {
            if (!ModPiglinBruteAi.makesPiglinBrutesNeutral(livingEntity.getItemBySlot(equipmentSlot))) continue;
            return true;
        }
        return false;
    }

    private static boolean makesPiglinBrutesNeutral(ItemStack itemStack) {
        return itemStack.is(ModTags.PIGLIN_BRUTE_SAFE_ARMOR_ITEM_TAG_KEY) && ModPiglinBruteAi.makesPiglinsNeutral(itemStack);
    }

    public static boolean makesPiglinsNeutral(ItemStack itemStack) {
        ArmorTrim armorTrim = (ArmorTrim)itemStack.get(DataComponents.TRIM);
        return armorTrim != null && armorTrim.material().is(ModTags.PIGLIN_SAFE_TRIM_MATERIAL_TAG_KEY);
    }
}

