/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.expore.world.feature;

import com.blocklegend001.expore.world.feature.ModConfiguredFeatures;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> EXP_PLACED_KEY = ModPlacedFeatures.createKey("exp_placed");
    public static final ResourceKey<PlacedFeature> NETHER_EXP_PLACED_KEY = ModPlacedFeatures.createKey("nether_exp_ore_placed");
    public static final ResourceKey<PlacedFeature> END_EXP_PLACED_KEY = ModPlacedFeatures.createKey("end_exp_ore_placed");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        Holder.Reference overworldExpOre = configuredFeatures.getOrThrow(ModConfiguredFeatures.OVERWORLD_EXP_ORE_KEY);
        Holder.Reference netherExpOre = configuredFeatures.getOrThrow(ModConfiguredFeatures.NETHER_EXP_ORE_KEY);
        Holder.Reference endExpOre = configuredFeatures.getOrThrow(ModConfiguredFeatures.END_EXP_ORE_KEY);
        ModPlacedFeatures.register(context, EXP_PLACED_KEY, overworldExpOre, ModPlacedFeatures.commonOrePlacement(9, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)-80), (VerticalAnchor)VerticalAnchor.absolute((int)80))));
        ModPlacedFeatures.register(context, NETHER_EXP_PLACED_KEY, netherExpOre, ModPlacedFeatures.commonOrePlacement(9, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)125))));
        ModPlacedFeatures.register(context, END_EXP_PLACED_KEY, endExpOre, ModPlacedFeatures.commonOrePlacement(9, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)255))));
    }

    public static List<PlacementModifier> orePlacement(PlacementModifier p_195347_, PlacementModifier p_195348_) {
        return List.of(p_195347_, InSquarePlacement.spread(), p_195348_, BiomeFilter.biome());
    }

    public static List<PlacementModifier> commonOrePlacement(int p_195344_, PlacementModifier p_195345_) {
        return ModPlacedFeatures.orePlacement((PlacementModifier)CountPlacement.of((int)p_195344_), p_195345_);
    }

    private static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (Identifier)Identifier.fromNamespaceAndPath((String)"expore", (String)name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> feature, List<PlacementModifier> placementModifiers) {
        context.register(key, (Object)new PlacedFeature(feature, placementModifiers));
    }
}

