/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.findercompass.client;

import atomicstryker.findercompass.client.CompassSetting;
import atomicstryker.findercompass.client.FinderCompassClientTicker;
import atomicstryker.findercompass.client.FinderCompassLogic;
import atomicstryker.findercompass.common.CompassTargetData;
import atomicstryker.findercompass.common.FinderCompassMod;
import java.util.Map;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.GuiLayer;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(value={Dist.CLIENT}, modid="findercompass")
public class CompassRenderHook {
    private static final int[] strongholdNeedlecolor = new int[]{102, 0, 153};
    private static Minecraft mc = null;
    private static final ItemStack compassStack = new ItemStack((ItemLike)Items.COMPASS);
    private static double onScreenPositionWidth;
    private static double onScreenPositionHeight;
    private static double needleWidthOfScreenWidth;
    private static double needleHeightOfScreenHeight;
    private static Boolean mustHoldCompassInHandToBeActive;

    @SubscribeEvent
    public static void registerGuiLayers(RegisterGuiLayersEvent event) {
        Minecraft mc = Minecraft.getInstance();
        event.registerAboveAll(Identifier.fromNamespaceAndPath((String)"findercompass", (String)"findercompassrenderer"), (GuiLayer)new FinderCompassGuiOverlay());
    }

    private static void updateConfigValues() {
        if (mustHoldCompassInHandToBeActive == null) {
            FinderCompassMod.instance.initIfNeeded();
            onScreenPositionWidth = FinderCompassMod.instance.compassConfig.getOnScreenPositionWidth();
            onScreenPositionHeight = FinderCompassMod.instance.compassConfig.getOnScreenPositionHeight();
            needleWidthOfScreenWidth = FinderCompassMod.instance.compassConfig.getNeedleWidthOfScreenWidth();
            needleHeightOfScreenHeight = FinderCompassMod.instance.compassConfig.getNeedleHeightOfScreenHeight();
            mustHoldCompassInHandToBeActive = FinderCompassMod.instance.compassConfig.isMustHoldCompassInHandToBeActive();
        }
    }

    private static boolean playerHasCompass() {
        if (CompassRenderHook.mc.player != null) {
            if (mustHoldCompassInHandToBeActive.booleanValue()) {
                if (CompassRenderHook.mc.player.getMainHandItem().getItem() == Items.COMPASS || CompassRenderHook.mc.player.getOffhandItem().getItem() == Items.COMPASS) {
                    return true;
                }
            } else {
                int compassSlot = CompassRenderHook.mc.player.getInventory().findSlotMatchingItem(compassStack);
                return Inventory.isHotbarSlot((int)compassSlot);
            }
        }
        return false;
    }

    private static void renderCompassNeedles(GuiGraphics guiGraphics) {
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        CompassSetting css = FinderCompassClientTicker.instance.getCurrentSetting();
        int widthNeedle = (int)Math.rint((double)screenWidth * (needleWidthOfScreenWidth / 2.0));
        int heightNeedle = (int)Math.rint((double)screenHeight * (needleHeightOfScreenHeight / 2.0));
        int originPointX = (int)Math.rint((double)screenWidth * onScreenPositionWidth);
        int originPointY = (int)Math.rint((double)screenHeight * onScreenPositionHeight);
        originPointX -= widthNeedle / 2;
        for (Map.Entry<CompassTargetData, BlockPos> entryTarget : css.getCustomNeedleTargets().entrySet()) {
            int[] configInts = css.getCustomNeedles().get(entryTarget.getKey());
            CompassRenderHook.drawNeedle(guiGraphics, widthNeedle, heightNeedle, originPointX, originPointY, configInts[0], configInts[1], configInts[2], CompassRenderHook.computeNeedleHeading(entryTarget.getValue()));
        }
        if (css.getFeatureNeedle() != null && FinderCompassLogic.hasFeature) {
            CompassRenderHook.drawNeedle(guiGraphics, widthNeedle, heightNeedle, originPointX, originPointY, strongholdNeedlecolor[0], strongholdNeedlecolor[1], strongholdNeedlecolor[2], CompassRenderHook.computeNeedleHeading(FinderCompassLogic.featureCoords));
        }
    }

    private static void drawNeedle(GuiGraphics guiGraphics, int widthNeedle, int heightNeedle, int originPointX, int originPointY, int r, int g, int b, float angleDegrees) {
        float angleRadian = (float)Math.toRadians(angleDegrees);
        int color = -16777216;
        color |= b;
        color |= g << 8;
        color |= r << 16;
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)originPointX, (float)originPointY);
        guiGraphics.pose().rotate(angleRadian);
        int startHeight = heightNeedle / 2;
        int halfWidth = widthNeedle / 2;
        guiGraphics.fill(startHeight, -halfWidth, heightNeedle, widthNeedle, color);
        guiGraphics.pose().popMatrix();
    }

    private static float computeNeedleHeading(BlockPos coords) {
        double angleDegrees = 0.0;
        if (CompassRenderHook.mc.level != null && CompassRenderHook.mc.player != null) {
            double playerX = CompassRenderHook.mc.player.getX();
            double playerZ = CompassRenderHook.mc.player.getZ();
            double blockX = (double)coords.getX() + 0.5;
            double blockZ = (double)coords.getZ() + 0.5;
            double xDiff = playerX - blockX;
            double zDiff = playerZ - blockZ;
            angleDegrees = (double)CompassRenderHook.mc.player.getYRot() * Math.PI / 180.0 - Math.atan2(zDiff, xDiff);
        }
        return (float)(-(angleDegrees * 180.0 / Math.PI));
    }

    static {
        mustHoldCompassInHandToBeActive = null;
    }

    public static class FinderCompassGuiOverlay
    implements GuiLayer {
        public void render(@NotNull GuiGraphics guiGraphics, DeltaTracker partialTick) {
            if (mc == null) {
                mc = Minecraft.getInstance();
            }
            CompassRenderHook.updateConfigValues();
            if (CompassRenderHook.playerHasCompass()) {
                CompassRenderHook.renderCompassNeedles(guiGraphics);
            }
        }
    }
}

