/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.findercompass.client;

import atomicstryker.findercompass.client.FinderCompassClientTicker;
import atomicstryker.findercompass.client.FinderCompassLogic;
import atomicstryker.findercompass.common.FinderCompassMod;
import atomicstryker.findercompass.common.ISidedProxy;
import atomicstryker.findercompass.common.network.FeatureSearchPacket;
import atomicstryker.findercompass.common.network.HandshakePacket;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class FinderCompassClient
implements ISidedProxy {
    private static final FinderCompassClient INSTANCE = new FinderCompassClient();

    public static FinderCompassClient getInstance() {
        return INSTANCE;
    }

    @Override
    public void commonSetup() {
        FinderCompassClientTicker.instance = new FinderCompassClientTicker();
        FinderCompassClientTicker.instance.onLoad();
        FinderCompassClientTicker.instance.switchSetting();
    }

    @Override
    public Path getMcFolder() {
        return Minecraft.getInstance().gameDirectory.toPath();
    }

    public void handleHandshake(HandshakePacket handShakePacket, IPayloadContext context) {
        FinderCompassMod.instance.initIfNeeded();
        FinderCompassMod.LOGGER.info("client received Finder Compass HandshakePacket, from username: {}", (Object)handShakePacket.username());
        if (handShakePacket.username().equals("server")) {
            String json = handShakePacket.json();
            FinderCompassMod.LOGGER.info("deferring config override task with json of length {}", (Object)json.length());
            Minecraft.getInstance().submitAsync(() -> {
                FinderCompassMod.LOGGER.info("executing deferred config override, FinderCompassClientTicker.instance is: {}", (Object)FinderCompassClientTicker.instance);
                FinderCompassClientTicker.instance.inputOverrideConfig(json);
            });
        }
    }

    public static void handleFeatureSearch(FeatureSearchPacket packet, IPayloadContext context) {
        if (packet.username().equals("server")) {
            Minecraft.getInstance().submitAsync(() -> {
                FinderCompassLogic.featureCoords = new BlockPos(packet.x(), packet.y(), packet.z());
                FinderCompassMod.LOGGER.debug("Finder Compass server sent Feature {} coords: [{}|{}|{}]", (Object)packet.featureId(), (Object)packet.x(), (Object)packet.y(), (Object)packet.z());
                FinderCompassLogic.hasFeature = true;
            });
        } else {
            ServerLifecycleHooks.getCurrentServer().submitAsync(() -> {
                ServerPlayer p = ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayerByName(packet.username());
                if (p != null) {
                    BlockPos result = FinderCompassMod.instance.findLevelStructure(p.level(), p.getOnPos(), packet.featureId());
                    FinderCompassMod.LOGGER.debug("server searched for feature {} for user {}, result {}", (Object)packet.featureId(), (Object)packet.username(), (Object)result);
                    if (result != null) {
                        FeatureSearchPacket featureSearchPacket = new FeatureSearchPacket(result.getX(), result.getY(), result.getZ(), "server", packet.featureId());
                        PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)featureSearchPacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                }
            });
        }
    }
}

