/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.findercompass.client;

import atomicstryker.findercompass.client.CompassSetting;
import atomicstryker.findercompass.client.FinderCompassLogic;
import atomicstryker.findercompass.common.CompassConfig;
import atomicstryker.findercompass.common.CompassTargetData;
import atomicstryker.findercompass.common.FinderCompassMod;
import atomicstryker.findercompass.common.GsonConfig;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class FinderCompassClientTicker {
    public static FinderCompassClientTicker instance;
    private Minecraft mc;
    public FinderCompassLogic compassLogic;
    private CompassSetting currentSetting;
    private boolean repeat;

    public FinderCompassClientTicker() {
        instance = this;
        this.repeat = false;
        this.currentSetting = null;
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void playerLoginToServer(ClientPlayerNetworkEvent.LoggingIn evt) {
        FinderCompassMod.instance.initIfNeeded();
    }

    public void onLoad() {
        this.mc = Minecraft.getInstance();
        this.compassLogic = new FinderCompassLogic(this.mc);
    }

    @SubscribeEvent
    public void onTick(PlayerTickEvent.Post tick) {
        if (this.compassLogic != null) {
            if (tick.getEntity().getItemInHand(InteractionHand.MAIN_HAND).getItem() == Items.COMPASS) {
                if (this.mc.options.keyAttack.isDown()) {
                    if (!this.repeat) {
                        this.repeat = true;
                        this.switchSetting();
                        tick.getEntity().level().playSound(null, new BlockPos((Vec3i)tick.getEntity().getOnPos()), (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.BLOCKS, 0.3f, 0.6f);
                    }
                } else {
                    this.repeat = false;
                }
            }
            this.compassLogic.onTick();
        }
    }

    public CompassSetting getCurrentSetting() {
        return this.currentSetting;
    }

    public void switchSetting() {
        int nextIndex;
        if (this.getSettingsList().isEmpty()) {
            return;
        }
        if (this.currentSetting == null) {
            nextIndex = 0;
        } else {
            this.currentSetting.onDisableThisConfig();
            nextIndex = this.getSettingsList().indexOf(this.currentSetting) + 1;
            if (nextIndex >= this.getSettingsList().size()) {
                nextIndex = 0;
            }
        }
        this.currentSetting = this.getSettingsList().get(nextIndex);
        FinderCompassLogic.hasFeature = false;
        if (this.mc.level != null) {
            this.mc.level.playSound((Entity)this.mc.player, new BlockPos((Vec3i)this.mc.player.getOnPos()), (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.BLOCKS, 0.3f, 0.6f);
            this.mc.gui.getChat().addMessage((Component)Component.literal((String)("Finder Compass Mode: " + this.currentSetting.getName())));
        }
    }

    public void inputOverrideConfig(String json) {
        this.getSettingsList().clear();
        FinderCompassMod.LOGGER.info("inputting Finder Compass config from serverside: {}", (Object)json);
        CompassConfig compassConfig = GsonConfig.loadConfigFromString(CompassConfig.class, json);
        FinderCompassMod.instance.loadSettingListFromConfig(compassConfig);
        this.mc.gui.getChat().addMessage((Component)Component.literal((String)("Finder Compass server config loaded; " + this.getSettingsList().size() + " custom Setting-Sets loaded")));
    }

    public void onFoundChunkCoordinates(BlockPos input, BlockState blockState) {
        CompassTargetData key = new CompassTargetData(blockState);
        this.currentSetting.getNewFoundTargets().put(key, input);
    }

    private ArrayList<CompassSetting> getSettingsList() {
        return FinderCompassMod.instance.settingList;
    }
}

