/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.findercompass.client;

import atomicstryker.findercompass.client.CompassSetting;
import atomicstryker.findercompass.client.FinderCompassClientTicker;
import atomicstryker.findercompass.client.ThreadCompassWorker;
import atomicstryker.findercompass.common.CompassTargetData;
import atomicstryker.findercompass.common.FinderCompassMod;
import atomicstryker.findercompass.common.network.FeatureSearchPacket;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class FinderCompassLogic {
    private final ItemStack compassStack = new ItemStack((ItemLike)Items.COMPASS);
    public static BlockPos featureCoords = new BlockPos(0, 0, 0);
    public static boolean hasFeature = false;
    private final BlockPos NullChunk = new BlockPos(0, 0, 0);
    private final Minecraft mc;
    private BlockPos oldPos;
    private long nextTime;
    private int seccounter;

    public FinderCompassLogic(Minecraft minecraft) {
        this.mc = minecraft;
        this.seccounter = 0;
        this.nextTime = System.currentTimeMillis();
    }

    public void onTick() {
        if (this.mc.level != null && this.mc.player != null) {
            boolean is15SecInterval = false;
            boolean movement = false;
            if (System.currentTimeMillis() > this.nextTime && this.playerHasCompass()) {
                ++this.seccounter;
            } else {
                return;
            }
            this.nextTime = System.currentTimeMillis() + 1000L;
            BlockPos pos = new BlockPos((Vec3i)this.mc.player.getOnPos());
            if (!pos.equals((Object)this.oldPos)) {
                this.oldPos = pos;
                movement = true;
            }
            if (this.seccounter > 14) {
                this.seccounter = 0;
                is15SecInterval = true;
                hasFeature = false;
            }
            if (movement) {
                CompassSetting currentSetting = FinderCompassClientTicker.instance.getCurrentSetting();
                Iterator<Map.Entry<CompassTargetData, int[]>> iter = currentSetting.getCustomNeedles().entrySet().iterator();
                if (is15SecInterval && currentSetting.getFeatureNeedle() != null && this.mc.player.connection.hasChannel(FeatureSearchPacket.TYPE.id())) {
                    FeatureSearchPacket featureSearchPacket = new FeatureSearchPacket(this.mc.player.getOnPos().getX(), this.mc.player.getOnPos().getY(), this.mc.player.getOnPos().getZ(), this.mc.player.getName().getString(), currentSetting.getFeatureNeedle());
                    ClientPacketDistributor.sendToServer((CustomPacketPayload)featureSearchPacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                while (iter.hasNext()) {
                    Map.Entry<CompassTargetData, int[]> iterEntry = iter.next();
                    CompassTargetData targetData = iterEntry.getKey();
                    int[] configInts = iterEntry.getValue();
                    if (!is15SecInterval && configInts[7] != 0) continue;
                    BlockPos coords = this.findNearestBlockChunkOfIDInRange(currentSetting, targetData.getBlockState(), pos.getX(), pos.getY(), pos.getZ(), configInts[3], configInts[4], configInts[5], configInts[6]);
                    if (coords != null && !coords.equals((Object)this.NullChunk)) {
                        currentSetting.getCustomNeedleTargets().put(targetData, coords);
                        continue;
                    }
                    currentSetting.getCustomNeedleTargets().remove(targetData);
                }
            }
        }
    }

    private boolean playerHasCompass() {
        if (this.mc.player != null) {
            if (FinderCompassMod.instance.compassConfig.isMustHoldCompassInHandToBeActive()) {
                return this.mc.player.getMainHandItem().getItem() == Items.COMPASS || this.mc.player.getOffhandItem().getItem() == Items.COMPASS;
            }
            int compassSlot = this.mc.player.getInventory().findSlotMatchingItem(this.compassStack);
            return Inventory.isHotbarSlot((int)compassSlot);
        }
        return false;
    }

    private BlockPos findNearestBlockChunkOfIDInRange(CompassSetting currentSetting, BlockState blockState, int playerX, int playerY, int playerZ, int xzRange, int yRange, int minY, int maxY) {
        BlockPos result;
        CompassTargetData key = new CompassTargetData(blockState);
        ThreadCompassWorker worker = currentSetting.getCompassWorkers().get(key);
        if (worker == null || !worker.isWorking()) {
            worker = new ThreadCompassWorker(this.mc);
            worker.setPriority(1);
            currentSetting.getCompassWorkers().put(key, worker);
            worker.setupValues(blockState, playerX, playerY, playerZ, xzRange, yRange, minY, maxY);
            worker.start();
        }
        if ((result = currentSetting.getNewFoundTargets().get(key)) == null) {
            result = currentSetting.getCustomNeedleTargets().get(key);
        } else {
            currentSetting.getNewFoundTargets().remove(key);
        }
        return result;
    }
}

