/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.findercompass.client;

import atomicstryker.findercompass.client.FinderCompassClientTicker;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThreadCompassWorker
extends Thread {
    private static final Logger LOGGER = LogManager.getLogger();
    private Minecraft mcinstance;
    private boolean isRunning = false;
    private BlockState blockState;
    private int playerX;
    private int playerY;
    private int playerZ;
    private int xzRange;
    private int yRange;
    private int minY;
    private int maxY;

    public ThreadCompassWorker(Minecraft mc) {
        this.mcinstance = mc;
    }

    public void setupValues(BlockState b, int pX, int pY, int pZ, int xzR, int yR, int mnY, int mxY) {
        this.blockState = b;
        this.playerX = pX;
        this.playerY = pY;
        this.playerZ = pZ;
        this.xzRange = xzR;
        this.yRange = yR;
        this.minY = mnY;
        this.maxY = mxY;
    }

    public boolean isWorking() {
        return this.isRunning;
    }

    @Override
    public void run() {
        this.isRunning = true;
        LOGGER.debug("compass worker started search for blockstate {} from player pos {}", (Object)this.blockState, (Object)new BlockPos(this.playerX, this.playerY, this.playerZ));
        BlockPos result = this.findNearestBlockChunkOfIDInRange();
        if (result != null) {
            FinderCompassClientTicker.instance.onFoundChunkCoordinates(result, this.blockState);
        }
        this.isRunning = false;
    }

    private BlockPos findNearestBlockChunkOfIDInRange() {
        List<BlockPos> blocksInRange = this.findBlocksOfIDInRange();
        BlockPos playerCoords = new BlockPos(this.playerX, this.playerY, this.playerZ);
        BlockPos resultCoords = new BlockPos(0, 0, 0);
        double minDist = 9999.0;
        for (BlockPos coords : blocksInRange) {
            double localDist = playerCoords.distSqr((Vec3i)coords);
            if (!(localDist < minDist)) continue;
            resultCoords = coords;
            minDist = localDist;
            LOGGER.debug("Compassworker found stuff for block {} at coords {}, player distance {}", (Object)this.blockState.getBlock(), (Object)coords, (Object)minDist);
        }
        return resultCoords;
    }

    private List<BlockPos> findBlocksOfIDInRange() {
        ArrayList<BlockPos> resultList = new ArrayList<BlockPos>();
        int counter = 0;
        for (int yIter = this.playerY - this.yRange; yIter <= this.playerY + this.yRange + 1; ++yIter) {
            if (yIter >= this.minY && yIter <= this.maxY) {
                for (int zIter = this.playerZ - this.xzRange; zIter <= this.playerZ + this.xzRange; ++zIter) {
                    for (int xIter = this.playerX - this.xzRange; xIter <= this.playerX + this.xzRange; ++xIter) {
                        BlockState state = this.mcinstance.level.getBlockState(new BlockPos(xIter, yIter, zIter));
                        ++counter;
                        if (state.getBlock() == this.blockState.getBlock()) {
                            resultList.add(new BlockPos(xIter, yIter, zIter));
                            LOGGER.trace("block match at {}! state match: {}", (Object)new BlockPos(xIter, yIter, zIter), (Object)(state == this.blockState ? 1 : 0));
                        }
                        Thread.yield();
                    }
                }
                continue;
            }
            LOGGER.debug("minY {} maxY {} yIter {} not inside configured Y range, skipping", (Object)this.minY, (Object)this.maxY, (Object)yIter);
        }
        return resultList;
    }
}

