/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.findercompass.common;

import atomicstryker.findercompass.client.CompassSetting;
import atomicstryker.findercompass.client.FinderCompassClient;
import atomicstryker.findercompass.common.CompassConfig;
import atomicstryker.findercompass.common.CompassTargetData;
import atomicstryker.findercompass.common.FinderCompassServer;
import atomicstryker.findercompass.common.GsonConfig;
import atomicstryker.findercompass.common.ISidedProxy;
import atomicstryker.findercompass.common.network.FeatureSearchPacket;
import atomicstryker.findercompass.common.network.HandshakePacket;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="findercompass")
public class FinderCompassMod {
    public static final String MOD_ID = "findercompass";
    public static final Logger LOGGER = LogManager.getLogger();
    public static FinderCompassMod instance;
    public static ISidedProxy proxy;
    public CompassConfig compassConfig;
    public ArrayList<CompassSetting> settingList;

    public FinderCompassMod(IEventBus modEventBus) {
        instance = this;
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::registerNetworking);
    }

    private void registerNetworking(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MOD_ID).optional();
        registrar.playToClient(HandshakePacket.TYPE, HandshakePacket.STREAM_CODEC, (payload, context) -> FinderCompassClient.getInstance().handleHandshake((HandshakePacket)payload, context));
        registrar.playBidirectional(FeatureSearchPacket.TYPE, FeatureSearchPacket.STREAM_CODEC, FinderCompassServer::handleFeatureSearch, FinderCompassClient::handleFeatureSearch);
    }

    @SubscribeEvent
    public void serverStarted(ServerStartedEvent evt) {
        this.initIfNeeded();
    }

    public void initIfNeeded() {
        if (this.compassConfig == null) {
            this.compassConfig = this.createDefaultConfig();
            try {
                this.compassConfig = GsonConfig.loadConfigWithDefault(CompassConfig.class, proxy.getMcFolder().resolve("config" + File.separator + "findercompass.cfg").toFile(), this.compassConfig);
                this.loadSettingListFromConfig(this.compassConfig);
                proxy.commonSetup();
            }
            catch (IOException e) {
                LOGGER.error("IOException parsing config", (Throwable)e);
            }
        }
    }

    public void loadSettingListFromConfig(CompassConfig input) {
        this.compassConfig = input;
        this.settingList = new ArrayList();
        for (CompassConfig.NeedleSet needleSet : this.compassConfig.getNeedles()) {
            CompassSetting setting = new CompassSetting(needleSet.getName(), needleSet.getFeatureNeedle());
            for (Map.Entry<String, int[]> blockEntry : needleSet.getNeedles().entrySet()) {
                BlockState state = this.getBlockStateFromString(blockEntry.getKey());
                if (state != null) {
                    CompassTargetData data = new CompassTargetData(state);
                    setting.getCustomNeedles().put(data, blockEntry.getValue());
                    LOGGER.info("{}: parsed blockstate {} for colors {}", (Object)needleSet.getName(), (Object)state, (Object)blockEntry.getValue());
                    continue;
                }
                LOGGER.error("Could not identify block for input {}", (Object)blockEntry.getKey());
            }
            this.settingList.add(setting);
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        LOGGER.info("Server sending Finder Compass Handshake to player {}", (Object)event.getEntity().getDisplayName());
        HandshakePacket packet = new HandshakePacket("server", GsonConfig.jsonFromConfig(this.compassConfig));
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)event.getEntity()), (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private String getStringFromBlockState(BlockState blockState) {
        HashMap<String, String> blockMap = new HashMap<String, String>();
        blockMap.put("block", BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock()).toString());
        for (Property property : blockState.getBlock().getStateDefinition().getProperties()) {
            blockMap.put(property.getName(), blockState.getValue(property).toString());
        }
        Gson gson = new Gson();
        return gson.toJson(blockMap);
    }

    private BlockState getBlockStateFromString(String json) {
        Gson gson = new Gson();
        Map blockMap = (Map)gson.fromJson(json, HashMap.class);
        String resourceAsString = (String)blockMap.get("block");
        Optional blockOptional = BuiltInRegistries.BLOCK.getOptional(Identifier.parse((String)resourceAsString));
        if (blockOptional.isEmpty()) {
            return null;
        }
        Block block = (Block)blockOptional.get();
        BlockState reconstructedState = block.defaultBlockState();
        for (Property property : block.getStateDefinition().getProperties()) {
            reconstructedState = this.setValueHelper(reconstructedState, property, property.getName(), (String)blockMap.get(property.getName()));
        }
        return reconstructedState;
    }

    private <S extends StateHolder<?, S>, T extends Comparable<T>> S setValueHelper(S blockState, Property<T> property, String propertyName, String valueString) {
        Optional optional = property.getValue(valueString);
        if (optional.isPresent()) {
            return (S)((StateHolder)blockState.setValue(property, (Comparable)optional.get()));
        }
        LOGGER.warn("Unable to read property: {} with value: {} for blockstate: {}", (Object)propertyName, (Object)valueString, (Object)blockState.toString());
        return blockState;
    }

    private CompassConfig createDefaultConfig() {
        CompassConfig compassConfig = new CompassConfig();
        ArrayList<CompassConfig.NeedleSet> needleSetList = new ArrayList<CompassConfig.NeedleSet>();
        CompassConfig.NeedleSet workingManMineables = new CompassConfig.NeedleSet();
        workingManMineables.setName("Working Man's Mineables");
        HashMap<String, Object> needleMap = new HashMap<String, int[]>();
        BlockState state = Blocks.GOLD_ORE.defaultBlockState();
        String string = this.getStringFromBlockState(state);
        needleMap.put(string, this.getSettingIntArray(245, 245, 0, 15, 1, 0, 384, 0));
        state = Blocks.DEEPSLATE_GOLD_ORE.defaultBlockState();
        string = this.getStringFromBlockState(state);
        needleMap.put(string, this.getSettingIntArray(245, 245, 0, 15, 1, -64, 0, 0));
        state = Blocks.IRON_ORE.defaultBlockState();
        string = this.getStringFromBlockState(state);
        needleMap.put(string, this.getSettingIntArray(112, 112, 112, 15, 1, 0, 384, 0));
        state = Blocks.DEEPSLATE_IRON_ORE.defaultBlockState();
        string = this.getStringFromBlockState(state);
        needleMap.put(string, this.getSettingIntArray(112, 112, 112, 15, 1, -64, 0, 0));
        state = Blocks.COAL_ORE.defaultBlockState();
        string = this.getStringFromBlockState(state);
        needleMap.put(string, this.getSettingIntArray(51, 26, 0, 15, 1, 0, 384, 0));
        state = Blocks.DEEPSLATE_COAL_ORE.defaultBlockState();
        string = this.getStringFromBlockState(state);
        needleMap.put(string, this.getSettingIntArray(51, 26, 0, 15, 1, -64, 0, 0));
        state = Blocks.COPPER_ORE.defaultBlockState();
        string = this.getStringFromBlockState(state);
        needleMap.put(string, this.getSettingIntArray(141, 83, 46, 15, 1, 0, 384, 0));
        state = Blocks.DEEPSLATE_COPPER_ORE.defaultBlockState();
        string = this.getStringFromBlockState(state);
        needleMap.put(string, this.getSettingIntArray(141, 83, 46, 15, 1, -64, 0, 0));
        workingManMineables.setNeedles(needleMap);
        workingManMineables.setFeatureNeedle("village");
        needleSetList.add(workingManMineables);
        CompassConfig.NeedleSet shinyStones = new CompassConfig.NeedleSet();
        shinyStones.setName("Shiny Stones");
        needleMap = new HashMap();
        state = Blocks.DIAMOND_ORE.defaultBlockState();
        string = this.getStringFromBlockState(state);
        needleMap.put(string, this.getSettingIntArray(51, 255, 204, 15, 1, 0, 384, 0));
        state = Blocks.DEEPSLATE_DIAMOND_ORE.defaultBlockState();
        string = this.getStringFromBlockState(state);
        needleMap.put(string, this.getSettingIntArray(51, 255, 204, 15, 1, -64, 0, 0));
        state = Blocks.LAPIS_ORE.defaultBlockState();
        string = this.getStringFromBlockState(state);
        needleMap.put(string, this.getSettingIntArray(55, 70, 220, 15, 1, 0, 384, 0));
        state = Blocks.DEEPSLATE_LAPIS_ORE.defaultBlockState();
        string = this.getStringFromBlockState(state);
        needleMap.put(string, this.getSettingIntArray(55, 70, 220, 15, 1, -64, 0, 0));
        state = Blocks.REDSTONE_ORE.defaultBlockState();
        string = this.getStringFromBlockState(state);
        needleMap.put(string, this.getSettingIntArray(255, 125, 155, 15, 1, 0, 384, 0));
        state = Blocks.DEEPSLATE_REDSTONE_ORE.defaultBlockState();
        string = this.getStringFromBlockState(state);
        needleMap.put(string, this.getSettingIntArray(255, 125, 155, 15, 1, -64, 0, 0));
        state = Blocks.EMERALD_ORE.defaultBlockState();
        string = this.getStringFromBlockState(state);
        needleMap.put(string, this.getSettingIntArray(26, 255, 26, 7, 1, 0, 384, 0));
        state = Blocks.DEEPSLATE_EMERALD_ORE.defaultBlockState();
        string = this.getStringFromBlockState(state);
        needleMap.put(string, this.getSettingIntArray(26, 255, 26, 7, 1, -64, 0, 0));
        shinyStones.setNeedles(needleMap);
        shinyStones.setFeatureNeedle("stronghold");
        needleSetList.add(shinyStones);
        CompassConfig.NeedleSet netherDelights = new CompassConfig.NeedleSet();
        netherDelights.setName("Nether Delights");
        needleMap = new HashMap();
        state = Blocks.NETHER_GOLD_ORE.defaultBlockState();
        string = this.getStringFromBlockState(state);
        needleMap.put(string, this.getSettingIntArray(245, 245, 0, 15, 1, 1, 256, 0));
        state = Blocks.ANCIENT_DEBRIS.defaultBlockState();
        string = this.getStringFromBlockState(state);
        needleMap.put(string, this.getSettingIntArray(51, 255, 204, 15, 1, 1, 16, 0));
        state = Blocks.NETHER_QUARTZ_ORE.defaultBlockState();
        string = this.getStringFromBlockState(state);
        needleMap.put(string, this.getSettingIntArray(55, 70, 220, 15, 1, 1, 256, 0));
        netherDelights.setNeedles(needleMap);
        netherDelights.setFeatureNeedle("fortress");
        needleSetList.add(netherDelights);
        compassConfig.setNeedles(needleSetList);
        compassConfig.setNeedleWidthOfScreenWidth(0.01);
        compassConfig.setNeedleHeightOfScreenHeight(0.1);
        compassConfig.setOnScreenPositionHeight(0.5);
        compassConfig.setOnScreenPositionWidth(0.5);
        compassConfig.setMustHoldCompassInHandToBeActive(true);
        return compassConfig;
    }

    private int[] getSettingIntArray(int colorRed, int colorGreen, int colorBlue, int xzSearchRange, int ySearchRange, int minY, int maxY, int boolSearchEvery15Sec) {
        return new int[]{colorRed, colorGreen, colorBlue, xzSearchRange, ySearchRange, minY, maxY, boolSearchEvery15Sec};
    }

    public BlockPos findLevelStructure(ServerLevel level, BlockPos searchPosition, String featureId) {
        TagKey configuredStructureFeatureTagKey = TagKey.create((ResourceKey)Registries.STRUCTURE, (Identifier)Identifier.parse((String)featureId));
        return level.findNearestMapStructure(configuredStructureFeatureTagKey, searchPosition, 160, false);
    }

    static {
        proxy = FMLEnvironment.getDist().isClient() ? new FinderCompassClient() : new FinderCompassServer();
    }
}

