/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.findercompass.common;

import atomicstryker.findercompass.common.FinderCompassMod;
import atomicstryker.findercompass.common.ISidedProxy;
import atomicstryker.findercompass.common.network.FeatureSearchPacket;
import java.nio.file.Path;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class FinderCompassServer
implements ISidedProxy {
    private static final FinderCompassServer INSTANCE = new FinderCompassServer();

    public static FinderCompassServer getInstance() {
        return INSTANCE;
    }

    @Override
    public void commonSetup() {
    }

    @Override
    public Path getMcFolder() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return server.getServerDirectory();
    }

    public static void handleFeatureSearch(FeatureSearchPacket packet, IPayloadContext context) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        server.submitAsync(() -> {
            ServerPlayer p = server.getPlayerList().getPlayerByName(packet.username());
            if (p != null) {
                BlockPos result = FinderCompassMod.instance.findLevelStructure(p.level(), p.getOnPos(), packet.featureId());
                FinderCompassMod.LOGGER.debug("server searched for feature {} for user {}, result {}", (Object)packet.featureId(), (Object)packet.username(), (Object)result);
                if (result != null) {
                    FeatureSearchPacket featureSearchPacket = new FeatureSearchPacket(result.getX(), result.getY(), result.getZ(), "server", packet.featureId());
                    PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)featureSearchPacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        });
    }
}

