/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.findercompass.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;

public class GsonConfig {
    private static JsonParser parser = new JsonParser();
    private static Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static <T> T loadConfigWithDefault(Class<T> clazz, File file, T defaultInstance) throws IOException {
        if (file.createNewFile()) {
            String json = gson.toJson(parser.parse(gson.toJson(defaultInstance)));
            try (PrintWriter out = new PrintWriter(file);){
                out.println(json);
            }
            return defaultInstance;
        }
        return (T)gson.fromJson(new String(Files.readAllBytes(file.toPath())), clazz);
    }

    public static <T> T loadConfigFromString(Class<T> clazz, String json) {
        return (T)gson.fromJson(json, clazz);
    }

    public static void saveConfig(Object config, File file) throws IOException {
        if (file.createNewFile()) {
            String json = gson.toJson(parser.parse(gson.toJson(config)));
            try (PrintWriter out = new PrintWriter(file);){
                out.println(json);
            }
        }
    }

    public static String jsonFromConfig(Object config) {
        return gson.toJson(parser.parse(gson.toJson(config)));
    }
}

