/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.gildedarmor.common.recipe;

import com.craftjakob.gildedarmor.configs.ServerConfig;
import com.craftjakob.gildedarmor.core.init.ModDataComponents;
import com.craftjakob.gildedarmor.core.init.ModRecipeSerializers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SmithingRecipeDisplay;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class GildedArmorSmithingRecipe
implements SmithingRecipe {
    private final Optional<Ingredient> template;
    private final Ingredient base;
    private final Optional<Ingredient> addition;

    public GildedArmorSmithingRecipe(Optional<Ingredient> template, Ingredient base, Optional<Ingredient> addition) {
        this.template = template;
        this.base = base;
        this.addition = addition;
    }

    public boolean matches(@NotNull SmithingRecipeInput recipeInput, @NotNull Level level) {
        return super.matches(recipeInput, level) && (recipeInput.base().is(ItemTags.HEAD_ARMOR) || recipeInput.base().is(ItemTags.CHEST_ARMOR) || recipeInput.base().is(ItemTags.LEG_ARMOR) || recipeInput.base().is(ItemTags.FOOT_ARMOR)) && !recipeInput.base().is(ItemTags.PIGLIN_SAFE_ARMOR) && !recipeInput.base().has((DataComponentType)ModDataComponents.GILDED.get());
    }

    @NotNull
    public ItemStack assemble(SmithingRecipeInput recipeInput, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return GildedArmorSmithingRecipe.applyModifications(recipeInput.base().copy());
    }

    public static ItemStack applyModifications(ItemStack base) {
        Equippable equippable = (Equippable)base.getOrDefault(DataComponents.EQUIPPABLE, (Object)Equippable.builder((EquipmentSlot)EquipmentSlot.BODY).build());
        EquipmentSlotGroup equipmentSlotGroup = EquipmentSlotGroup.bySlot((EquipmentSlot)equippable.slot());
        ItemAttributeModifiers modifiers = (ItemAttributeModifiers)base.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        ItemAttributeModifiers newModifiers = modifiers.withModifierAdded(Attributes.ARMOR, new AttributeModifier(Identifier.fromNamespaceAndPath((String)"gildedarmor", (String)"addition_armor"), ((Double)ServerConfig.ADDITIONAL_GILDED_ARMOR.getValue()).doubleValue(), AttributeModifier.Operation.ADD_VALUE), equipmentSlotGroup).withModifierAdded(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(Identifier.fromNamespaceAndPath((String)"gildedarmor", (String)"addition_armor_toughness"), ((Double)ServerConfig.ADDITIONAL_GILDED_ARMOR_TOUGHNESS.getValue()).doubleValue(), AttributeModifier.Operation.ADD_VALUE), equipmentSlotGroup);
        base.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)newModifiers);
        base.set((DataComponentType)ModDataComponents.GILDED.get(), (Object)true);
        return base;
    }

    @NotNull
    public RecipeSerializer<? extends SmithingRecipe> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.GILDED_ARMOR_SMITHING.get();
    }

    @NotNull
    public PlacementInfo placementInfo() {
        return PlacementInfo.createFromOptionals(List.of(this.template, Optional.of(this.base), this.addition));
    }

    @NotNull
    public Optional<Ingredient> templateIngredient() {
        return this.template;
    }

    @NotNull
    public Ingredient baseIngredient() {
        return this.base;
    }

    @NotNull
    public Optional<Ingredient> additionIngredient() {
        return this.addition;
    }

    @NotNull
    public List<RecipeDisplay> display() {
        return List.of(new SmithingRecipeDisplay(Ingredient.optionalIngredientToDisplay(this.template), this.base.display(), Ingredient.optionalIngredientToDisplay(this.addition), (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(GildedArmorSmithingRecipe.applyModifications(((Item)((Holder)this.base.items().findFirst().get()).value()).getDefaultInstance())), (SlotDisplay)new SlotDisplay.ItemSlotDisplay(Items.SMITHING_TABLE)));
    }

    public static class Serializer
    implements RecipeSerializer<GildedArmorSmithingRecipe> {
        private static final MapCodec<GildedArmorSmithingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.optionalFieldOf("template").forGetter(smithingRecipe -> smithingRecipe.template), (App)Ingredient.CODEC.fieldOf("base").forGetter(smithingRecipe -> smithingRecipe.base), (App)Ingredient.CODEC.optionalFieldOf("addition").forGetter(smithingRecipe -> smithingRecipe.addition)).apply((Applicative)instance, GildedArmorSmithingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, GildedArmorSmithingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.OPTIONAL_CONTENTS_STREAM_CODEC, smithingRecipe -> smithingRecipe.template, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, smithingRecipe -> smithingRecipe.base, (StreamCodec)Ingredient.OPTIONAL_CONTENTS_STREAM_CODEC, smithingRecipe -> smithingRecipe.addition, GildedArmorSmithingRecipe::new);

        @NotNull
        public MapCodec<GildedArmorSmithingRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, GildedArmorSmithingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

