/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.gravestone.GraveUtils;
import de.maxhenkel.gravestone.GravestoneMod;
import de.maxhenkel.gravestone.blocks.GraveStoneBlock;
import de.maxhenkel.gravestone.corelib.client.PlayerSkins;
import de.maxhenkel.gravestone.tileentity.GraveStoneTileEntity;
import de.maxhenkel.gravestone.tileentity.render.GravestoneRenderState;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.object.skull.SkullModel;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;

public class GravestoneRenderer
implements BlockEntityRenderer<GraveStoneTileEntity, GravestoneRenderState> {
    private final BlockEntityRendererProvider.Context renderer;

    public GravestoneRenderer(BlockEntityRendererProvider.Context renderer) {
        this.renderer = renderer;
    }

    public GravestoneRenderState createRenderState() {
        return new GravestoneRenderState();
    }

    public void extractRenderState(GraveStoneTileEntity grave, GravestoneRenderState state, float partialTicks, Vec3 pos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)grave, (BlockEntityRenderState)state, partialTicks, pos, crumblingOverlay);
        Component graveName = grave.getGraveName();
        state.name = graveName == null ? null : graveName.getVisualOrderText();
        state.direction = (Direction)grave.getBlockState().getValue(GraveStoneBlock.FACING);
        BlockState blockState = grave.getLevel().getBlockState(grave.getBlockPos().below());
        state.renderHead = blockState.isRedstoneConductor((BlockGetter)grave.getLevel(), grave.getBlockPos());
        state.playerId = grave.getDeath().getPlayerUUID();
    }

    public void submit(GravestoneRenderState state, PoseStack stack, SubmitNodeCollector collector, CameraRenderState cameraRenderState) {
        if (state.name == null) {
            return;
        }
        stack.pushPose();
        stack.translate(0.5, 1.0, 0.5);
        stack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(180.0f));
        stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f + state.direction.toYRot()));
        Font font = this.renderer.font();
        int textWidth = font.width(state.name);
        double textScale = Math.min(0.8 / (double)textWidth, 0.02);
        stack.translate(0.0, 0.3, 0.37);
        stack.scale((float)textScale, (float)textScale, (float)textScale);
        float left = -textWidth / 2;
        collector.submitText(stack, left, 0.0f, state.name, false, Font.DisplayMode.NORMAL, state.lightCoords, -1, 0, 0);
        stack.popPose();
        if (state.renderHead && state.playerId != null && !state.playerId.equals(GraveUtils.EMPTY_UUID) && ((Boolean)GravestoneMod.CLIENT_CONFIG.renderSkull.get()).booleanValue()) {
            this.renderSkull(collector, state, stack);
        }
    }

    public void renderSkull(SubmitNodeCollector collector, GravestoneRenderState state, PoseStack stack) {
        SkullModel model = new SkullModel(this.renderer.bakeLayer(ModelLayers.PLAYER_HEAD));
        Identifier resourcelocation = PlayerSkins.getSkin(state.playerId).body().texturePath();
        stack.pushPose();
        stack.translate(0.5, 0.0, 0.5);
        stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f - state.direction.toYRot()));
        stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-26.0f));
        stack.translate(0.0, -0.14, 0.18);
        stack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(180.0f));
        stack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-61.0f));
        int light = state.lightCoords;
        collector.submitCustomGeometry(stack, model.renderType(resourcelocation), (pose, vertexConsumer) -> {
            PoseStack s = new PoseStack();
            s.mulPose((Matrix4fc)pose.pose());
            model.renderToBuffer(s, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
        });
        stack.popPose();
    }
}

