/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.infusedfoods.cauldron;

import dev.apexstudios.infusedfoods.cauldron.PotionCauldronBlockEntity;
import dev.apexstudios.infusedfoods.cauldron.PotionCauldronInteractions;
import dev.apexstudios.infusedfoods.util.InfusionEntries;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public final class PotionCauldronBlock
extends LayeredCauldronBlock
implements EntityBlock {
    public PotionCauldronBlock(BlockBehaviour.Properties properties) {
        super(Biome.Precipitation.RAIN, PotionCauldronInteractions.INTERACTIONS, properties);
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        InteractionResult interactionResult = PotionCauldronInteractions.potionCauldron2Food(blockState, level, pos, player, hand, stack);
        if (interactionResult.consumesAction()) {
            return interactionResult;
        }
        return super.useItemOn(stack, blockState, level, pos, player, hand, result);
    }

    public void animateTick(BlockState blockState, Level level, BlockPos pos, RandomSource random) {
        PotionCauldronBlockEntity blockEntity = (PotionCauldronBlockEntity)InfusionEntries.CAULDRON_BLOCK_ENTITY.get((BlockGetter)level, pos);
        if (blockEntity == null) {
            return;
        }
        PotionContents potionContent = blockEntity.getPotionContents();
        Integer fluidLevel = (Integer)blockState.getValue((Property)LEVEL);
        ColorParticleOption particle = ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)potionContent.getColor());
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 0.5 + 0.25 * (double)fluidLevel.intValue();
        double z = (double)pos.getZ() + 0.5;
        for (int i = 0; i < 2; ++i) {
            int rand = random.nextInt(0, 4);
            if (rand == 0) {
                level.addParticle((ParticleOptions)particle, x + 0.25, y, z, 0.0, 0.0, 0.0);
                continue;
            }
            if (rand == 1) {
                level.addParticle((ParticleOptions)particle, x - 0.25, y, z, 0.0, 0.0, 0.0);
                continue;
            }
            if (rand == 2) {
                level.addParticle((ParticleOptions)particle, x, y, z + 0.25, 0.0, 0.0, 0.0);
                continue;
            }
            level.addParticle((ParticleOptions)particle, x, y, z - 0.25, 0.0, 0.0, 0.0);
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState blockState) {
        return new PotionCauldronBlockEntity(pos, blockState);
    }
}

