/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.infusedfoods.cauldron;

import dev.apexstudios.infusedfoods.util.InfusionEntries;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public final class PotionCauldronBlockEntity
extends BlockEntity {
    private static final String TAG_POTION = "PotionContents";
    private PotionContents potionContents = PotionContents.EMPTY;

    public PotionCauldronBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)InfusionEntries.CAULDRON_BLOCK_ENTITY.value(), pos, blockState);
    }

    public PotionContents getPotionContents() {
        return this.potionContents;
    }

    public void setPotionContents(PotionContents potionContents) {
        this.potionContents = potionContents;
        this.setChanged();
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.storeNullable(TAG_POTION, PotionContents.CODEC, (Object)this.potionContents);
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.potionContents = input.read(TAG_POTION, PotionContents.CODEC).orElse(PotionContents.EMPTY);
    }

    protected void applyImplicitComponents(DataComponentGetter components) {
        super.applyImplicitComponents(components);
        this.potionContents = (PotionContents)components.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(DataComponents.POTION_CONTENTS, (Object)this.potionContents);
    }

    public void removeComponentsFromTag(ValueOutput output) {
        super.removeComponentsFromTag(output);
        output.discard(TAG_POTION);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }
}

