/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.infusedfoods.cauldron;

import dev.apexstudios.infusedfoods.InfusedFoods;
import dev.apexstudios.infusedfoods.cauldron.PotionCauldronBlock;
import dev.apexstudios.infusedfoods.cauldron.PotionCauldronBlockEntity;
import dev.apexstudios.infusedfoods.util.InfusionEntries;
import dev.apexstudios.infusedfoods.util.InfusionUtil;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public interface PotionCauldronInteractions {
    public static final CauldronInteraction.InteractionMap INTERACTIONS = CauldronInteraction.newInteractionMap((String)InfusedFoods.id("potion_cauldron"));

    public static void registerInteractions() {
        Map map = CauldronInteraction.EMPTY.map();
        map.put(Items.POTION, PotionCauldronInteractions.any((InteractionResult)InteractionResult.TRY_WITH_EMPTY_HAND, PotionCauldronInteractions::waterBottle2WaterCauldron, PotionCauldronInteractions::cauldron2PotionCauldron));
        map = INTERACTIONS.map();
        map.put(Items.POTION, PotionCauldronInteractions::fromPotion);
        map.put(Items.GLASS_BOTTLE, PotionCauldronInteractions::toPotion);
    }

    private static InteractionResult cauldron2PotionCauldron(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        PotionContents contents = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        if (contents != PotionContents.EMPTY && contents.hasEffects()) {
            player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE)));
            player.awardStat(Stats.USE_CAULDRON);
            player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
            level.setBlockAndUpdate(pos, ((PotionCauldronBlock)((Object)InfusionEntries.CAULDRON_BLOCK.value())).defaultBlockState());
            ((PotionCauldronBlockEntity)level.getBlockEntity(pos)).setPotionContents(contents);
            level.playSound(null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult waterBottle2WaterCauldron(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        PotionContents contents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        if (contents != null && contents.is(Potions.WATER)) {
            Item item = stack.getItem();
            player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE)));
            player.awardStat(Stats.USE_CAULDRON);
            player.awardStat(Stats.ITEM_USED.get((Object)item));
            level.setBlockAndUpdate(pos, Blocks.WATER_CAULDRON.defaultBlockState());
            level.playSound(null, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult fromPotion(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        PotionContents contents = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        Integer fluidLevel = (Integer)blockState.getValue((Property)LayeredCauldronBlock.LEVEL);
        if (fluidLevel < 3 && PotionCauldronInteractions.setPotionContents(level, pos, contents, true, true, hand, player, stack)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult toPotion(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        PotionContents contents = ((PotionCauldronBlockEntity)InfusionEntries.CAULDRON_BLOCK_ENTITY.get((BlockGetter)level, pos)).getPotionContents();
        Integer fluidLevel = (Integer)blockState.getValue((Property)LayeredCauldronBlock.LEVEL);
        if (fluidLevel >= 1 && PotionCauldronInteractions.setPotionContents(level, pos, contents, false, true, hand, player, stack)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult potionCauldron2Food(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        if (InfusionUtil.isValidFood(stack) && !stack.has(DataComponents.POTION_CONTENTS)) {
            PotionCauldronBlockEntity blockEntity = (PotionCauldronBlockEntity)InfusionEntries.CAULDRON_BLOCK_ENTITY.get((BlockGetter)level, pos);
            PotionContents contents = blockEntity.getPotionContents();
            ItemStack filled = stack.copyWithCount(1);
            filled.set(DataComponents.POTION_CONTENTS, (Object)contents);
            stack.consume(1, (LivingEntity)player);
            player.addItem(filled);
            PotionCauldronInteractions.changeFillLevel(level, pos, blockState, false, false, player, stack);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static CauldronInteraction any(InteractionResult defaultResult, CauldronInteraction ... interactions) {
        return (blockState, level, pos, player, hand, stack) -> {
            for (CauldronInteraction interaction : interactions) {
                InteractionResult result = interaction.interact(blockState, level, pos, player, hand, stack);
                if (!result.consumesAction()) continue;
                return result;
            }
            return defaultResult;
        };
    }

    private static boolean setPotionContents(Level level, BlockPos pos, PotionContents newContents, boolean increment, boolean sounds, InteractionHand hand, Player player, ItemStack stack) {
        boolean isValidPotion;
        BlockState blockState = level.getBlockState(pos);
        PotionCauldronBlockEntity blockEntity = (PotionCauldronBlockEntity)InfusionEntries.CAULDRON_BLOCK_ENTITY.get((BlockGetter)level, pos);
        PotionContents current = blockEntity.getPotionContents();
        boolean itemHasPotion = newContents == PotionContents.EMPTY || newContents.hasEffects();
        Holder potion = newContents.potion().orElse(Potions.WATER);
        boolean bl = isValidPotion = current.is(potion) || InfusionUtil.isValidPotion((Holder<Potion>)potion);
        if (itemHasPotion && isValidPotion) {
            blockEntity.setPotionContents(newContents);
            ItemStack newStack = increment ? new ItemStack((ItemLike)Items.GLASS_BOTTLE) : PotionCauldronInteractions.createPotion(newContents);
            player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)newStack));
            PotionCauldronInteractions.changeFillLevel(level, pos, blockState, increment, sounds, player, stack);
            return true;
        }
        return false;
    }

    private static ItemStack createPotion(PotionContents contents) {
        ItemStack stack = new ItemStack((ItemLike)Items.POTION);
        stack.set(DataComponents.POTION_CONTENTS, (Object)contents);
        return stack;
    }

    private static void changeFillLevel(Level level, BlockPos pos, BlockState blockState, boolean increment, boolean sounds, Player player, ItemStack stack) {
        player.awardStat(Stats.USE_CAULDRON);
        player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
        if (increment) {
            BlockState newBlockState = (BlockState)blockState.setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf((Integer)blockState.getValue((Property)LayeredCauldronBlock.LEVEL) + 1));
            level.setBlockAndUpdate(pos, newBlockState);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)newBlockState));
            if (sounds) {
                level.playSound(null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            level.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, pos);
        } else {
            LayeredCauldronBlock.lowerFillLevel((BlockState)blockState, (Level)level, (BlockPos)pos);
            if (sounds) {
                level.playSound(null, pos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            level.gameEvent(null, (Holder)GameEvent.FLUID_PICKUP, pos);
        }
    }
}

