/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.infusedfoods.recipe;

import com.mojang.serialization.MapCodec;
import dev.apexstudios.infusedfoods.util.InfusionEntries;
import dev.apexstudios.infusedfoods.util.InfusionTags;
import dev.apexstudios.infusedfoods.util.InfusionUtil;
import dev.apexstudios.registree.impl.type.SimpleRecipeSerializer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;

public final class CleansingRecipe
extends CustomRecipe {
    public static final MapCodec<CleansingRecipe> CODEC = SimpleRecipeSerializer.codec(CleansingRecipe::new, CustomRecipe::category);
    public static final StreamCodec<RegistryFriendlyByteBuf, CleansingRecipe> STREAM_CODEC = SimpleRecipeSerializer.steamCodec(CleansingRecipe::new, CustomRecipe::category);

    @ApiStatus.Internal
    public CleansingRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, Level level) {
        ItemStack cleansingAgent = ItemStack.EMPTY;
        ItemStack food = ItemStack.EMPTY;
        for (ItemStack stack : input.items()) {
            if (stack.is(InfusionTags.CLEANSING_AGENT)) {
                if (!cleansingAgent.isEmpty()) {
                    return false;
                }
                cleansingAgent = stack;
                continue;
            }
            if (!InfusionUtil.isValidFood(stack) || !stack.has(DataComponents.POTION_CONTENTS)) continue;
            if (!food.isEmpty()) {
                return false;
            }
            food = stack;
        }
        return !cleansingAgent.isEmpty() && !food.isEmpty();
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack cleansingAgent = ItemStack.EMPTY;
        ItemStack food = ItemStack.EMPTY;
        for (ItemStack stack : input.items()) {
            if (stack.is(InfusionTags.CLEANSING_AGENT)) {
                if (!cleansingAgent.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                cleansingAgent = stack;
                continue;
            }
            if (!InfusionUtil.isValidFood(stack) || !stack.has(DataComponents.POTION_CONTENTS)) continue;
            if (!food.isEmpty()) {
                return ItemStack.EMPTY;
            }
            food = stack;
        }
        ItemStack result = food.copyWithCount(1);
        result.remove(DataComponents.POTION_CONTENTS);
        result.remove(InfusionEntries.HIDE_EFFECTS_COMPONENT);
        return result;
    }

    public RecipeSerializer<? extends CustomRecipe> getSerializer() {
        return (RecipeSerializer)InfusionEntries.CLEANSING_RECIPE.value();
    }
}

