/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.perf.dynamic_resources;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.PlayerSkinRenderCache;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.item.ClientItem;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.resources.model.AtlasManager;
import net.minecraft.client.resources.model.BlockStateModelLoader;
import net.minecraft.client.resources.model.ClientItemInfoLoader;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.ArrayUtils;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.duck.IModelHoldingBlockState;
import org.embeddedt.modernfix.dynamicresources.DynamicModelProvider;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ModelManager.class})
@ClientOnlyMixin
public class ModelManagerMixin
implements DynamicModelProvider.ModelManagerExtension {
    @Shadow
    private Map<Identifier, ItemModel> bakedItemStackModels;
    @Shadow
    private Map<Identifier, ClientItem.Properties> itemProperties;
    @Shadow
    @Final
    private AtlasManager atlasManager;
    @Final
    @Shadow
    private PlayerSkinRenderCache playerSkinRenderCache;
    @Unique
    private DynamicModelProvider mfix$modelProvider;

    @Redirect(method={"reload"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/resources/model/ModelManager;loadBlockModels(Lnet/minecraft/server/packs/resources/ResourceManager;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;"))
    private CompletableFuture<Map<Identifier, BlockModel>> deferBlockModelLoad(ResourceManager manager, Executor executor) {
        return CompletableFuture.completedFuture(Map.of());
    }

    @Redirect(method={"reload"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/resources/model/BlockStateModelLoader;loadBlockStates(Lnet/minecraft/server/packs/resources/ResourceManager;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;"))
    private CompletableFuture<BlockStateModelLoader.LoadedModels> deferBlockStateLoad(ResourceManager resourceManager, Executor executor) {
        return CompletableFuture.completedFuture(new BlockStateModelLoader.LoadedModels(Map.of()));
    }

    @Overwrite
    private static Map<BlockState, BlockStateModel> createBlockStateToModelDispatch(Map<BlockState, BlockStateModel> map, BlockStateModel missingModel) {
        DynamicModelProvider dynamicProvider = Objects.requireNonNull((DynamicModelProvider)DynamicModelProvider.currentReloadingModelProvider.get());
        return dynamicProvider.getFastTopLevelEmulatedRegistry();
    }

    @Redirect(method={"reload"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/resources/model/ClientItemInfoLoader;scheduleLoad(Lnet/minecraft/server/packs/resources/ResourceManager;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;"))
    private CompletableFuture<ClientItemInfoLoader.LoadedClientInfos> disableClientItemEarlyLoad(ResourceManager resourceManager, Executor executor) {
        return CompletableFuture.completedFuture(new ClientItemInfoLoader.LoadedClientInfos(Map.of()));
    }

    @ModifyArg(method={"reload"}, at=@At(value="INVOKE", target="Ljava/util/concurrent/CompletableFuture;allOf([Ljava/util/concurrent/CompletableFuture;)Ljava/util/concurrent/CompletableFuture;", ordinal=1))
    public CompletableFuture<?>[] createModelProviderCommon(CompletableFuture<?>[] futures) {
        CompletableFuture<?> itemPreparationsFuture = futures[1];
        CompletableFuture<?> blockPreparationsFuture = futures[0];
        CompletableFuture<?> entityModelSetFuture = futures[6];
        CompletionStage makeModelProviderFuture = CompletableFuture.allOf(itemPreparationsFuture, blockPreparationsFuture, entityModelSetFuture).thenApplyAsync(_void -> {
            this.mfix$modelProvider = new DynamicModelProvider(Minecraft.getInstance().getResourceManager(), (EntityModelSet)entityModelSetFuture.join(), (SpriteLoader.Preparations)blockPreparationsFuture.join(), (SpriteLoader.Preparations)itemPreparationsFuture.join(), this.playerSkinRenderCache, (MaterialSet)this.atlasManager);
            DynamicModelProvider.currentReloadingModelProvider = new WeakReference<DynamicModelProvider>(this.mfix$modelProvider);
            return _void;
        });
        return (CompletableFuture[])ArrayUtils.add((Object[])futures, (Object)makeModelProviderFuture);
    }

    @Inject(method={"apply"}, at={@At(value="RETURN")})
    private void setModelRegistries(CallbackInfo ci) {
        this.bakedItemStackModels = this.mfix$modelProvider.getItemModelEmulatedRegistry();
        this.itemProperties = this.mfix$modelProvider.getItemPropertiesEmulatedRegistry();
        for (Block block : BuiltInRegistries.BLOCK) {
            for (BlockState state : block.getStateDefinition().getPossibleStates()) {
                if (!(state instanceof IModelHoldingBlockState)) continue;
                IModelHoldingBlockState modelHolder = (IModelHoldingBlockState)state;
                modelHolder.mfix$setModel(null);
            }
        }
    }

    @Override
    public DynamicModelProvider mfix$getModelProvider() {
        return this.mfix$modelProvider;
    }
}

