/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.dynamicresources;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.PlayerSkinRenderCache;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.BlockModelDefinition;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.item.ClientItem;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.MissingItemModel;
import net.minecraft.client.renderer.item.ModelRenderProperties;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.BlockStateDefinitions;
import net.minecraft.client.resources.model.BlockStateModelLoader;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.client.resources.model.MissingBlockModel;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.client.resources.model.ModelDiscovery;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.client.resources.model.SpriteGetter;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.common.mixin.perf.dynamic_resources.BlockStateDefinitionsAccessor;
import org.embeddedt.modernfix.common.mixin.perf.dynamic_resources.BlockStateModelLoaderMixin;
import org.embeddedt.modernfix.common.mixin.perf.dynamic_resources.ModelWrapperInvoker;
import org.embeddedt.modernfix.duck.IModelHoldingBlockState;
import org.embeddedt.modernfix.dynamicresources.BlockStateSet;
import org.embeddedt.modernfix.dynamicresources.DynamicPartCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicModelProvider {
    private final LoadingCache<Identifier, Optional<BlockStateModelLoader.LoadedModels>> loadedStateDefinitions = this.makeLoadingCache(this::loadBlockStateDefinition);
    private final LoadingCache<Identifier, Optional<UnbakedModel>> loadedBlockModels = this.makeLoadingCache(this::loadBlockModel);
    private final LoadingCache<Identifier, Optional<ModelDiscovery.ModelWrapper>> resolvedBlockModels = this.makeLoadingCache(this::resolveBlockModel);
    private final LoadingCache<BlockState, Optional<BlockStateModel>> loadedBakedModels = this.makeLoadingCache(this::loadBakedModel);
    private final LoadingCache<Identifier, Optional<ClientItem>> loadedClientItemProperties = this.makeLoadingCache(this::loadClientItemProperties);
    private final LoadingCache<Identifier, Optional<ItemModel>> loadedItemModels = this.makeLoadingCache(this::loadItemModel);
    private final BlockStateModel missingModel;
    private final ModelDiscovery.ModelWrapper resolvedMissingModel;
    private final ItemModel missingItemModel;
    private final UnbakedModel unbakedMissingModel;
    private final Function<Identifier, StateDefinition<Block, BlockState>> stateMapper;
    private final ResourceManager resourceManager;
    private final SpriteGetter textureGetter;
    private final EntityModelSet entityModelSet;
    private final ItemModelGenerator itemModelGenerator;
    private final PlayerSkinRenderCache skinRenderCache;
    private final MaterialSet materialSet;
    private final ModelBaker.PartCache partCache;
    private final Map<BlockState, BlockStateModel> mrlModelOverrides = new ConcurrentHashMap<BlockState, BlockStateModel>();
    private final Map<Identifier, ItemModel> itemStackModelOverrides = new ConcurrentHashMap<Identifier, ItemModel>();
    private final Map<BlockState, BlockStateModel.Unbaked> unbakedBlockStateModelOverrides = new ConcurrentHashMap<BlockState, BlockStateModel.Unbaked>();
    private final List<DynamicModelPlugin> pluginList = new ArrayList<DynamicModelPlugin>();
    private static final boolean DEBUG_DYNAMIC_MODEL_LOADING = Boolean.getBoolean("modernfix.debugDynamicModelLoading");
    public static WeakReference<DynamicModelProvider> currentReloadingModelProvider = new WeakReference<Object>(null);

    public DynamicModelProvider(ResourceManager resourceManager, EntityModelSet entityModelSet, final SpriteLoader.Preparations blockPreparations, final SpriteLoader.Preparations itemPreparations, PlayerSkinRenderCache skinRenderCache, MaterialSet materialSet) {
        this.unbakedMissingModel = MissingBlockModel.missingModel();
        this.entityModelSet = entityModelSet;
        this.skinRenderCache = skinRenderCache;
        this.materialSet = materialSet;
        this.partCache = new DynamicPartCache();
        this.textureGetter = new SpriteGetter(){

            @NotNull
            public TextureAtlasSprite get(Material material, ModelDebugName modelDebugName) {
                Identifier atlas = material.atlasLocation();
                Boolean blockOrItemAtlas = atlas.equals((Object)ModelManager.BLOCK_OR_ITEM);
                Boolean itemAtlas = atlas.equals((Object)TextureAtlas.LOCATION_ITEMS);
                Boolean blockAtlas = atlas.equals((Object)TextureAtlas.LOCATION_BLOCKS);
                TextureAtlasSprite sprite = null;
                if (blockOrItemAtlas.booleanValue() || itemAtlas.booleanValue()) {
                    sprite = itemPreparations.getSprite(material.texture());
                }
                if (sprite == null && (blockOrItemAtlas.booleanValue() || blockAtlas.booleanValue())) {
                    sprite = blockPreparations.getSprite(material.texture());
                }
                if (sprite != null) {
                    return sprite;
                }
                ModernFix.LOGGER.warn("Unable to find sprite '{}' referenced by model '{}'", (Object)material.texture(), (Object)modelDebugName.debugName());
                if (!(blockOrItemAtlas.booleanValue() || blockAtlas.booleanValue() || itemAtlas.booleanValue())) {
                    ModernFix.LOGGER.warn(" -> Requested atlas ID '{}' was not part of the item or block atlas", (Object)atlas);
                }
                return itemAtlas != false ? itemPreparations.missing() : blockPreparations.missing();
            }

            @NotNull
            public TextureAtlasSprite reportMissingReference(String string, ModelDebugName modelDebugName) {
                return blockPreparations.missing();
            }
        };
        this.stateMapper = BlockStateDefinitions.definitionLocationToBlockStateMapper();
        this.resourceManager = resourceManager;
        this.itemModelGenerator = new ItemModelGenerator();
        this.resolvedMissingModel = ModelWrapperInvoker.mfix$invokeCtor(MissingBlockModel.LOCATION, this.unbakedMissingModel, true);
        ModelBaker missingModelBaker = new ModelBaker(){

            public ResolvedModel getModel(Identifier Identifier2) {
                throw new IllegalStateException("Missing model should not have dependencies");
            }

            public BlockModelPart missingBlockModelPart() {
                throw new IllegalStateException("Asked for missing model's missing model parts!");
            }

            public SpriteGetter sprites() {
                return DynamicModelProvider.this.textureGetter;
            }

            public ModelBaker.PartCache parts() {
                return DynamicModelProvider.this.partCache;
            }

            public <T> T compute(ModelBaker.SharedOperationKey<T> key) {
                return (T)key.compute((ModelBaker)this);
            }
        };
        TextureSlots textureSlots = this.resolvedMissingModel.getTopTextureSlots();
        final QuadCollection quadCollection = this.resolvedMissingModel.bakeTopGeometry(textureSlots, missingModelBaker, (ModelState)BlockModelRotation.IDENTITY);
        final TextureAtlasSprite particleSprite = this.resolvedMissingModel.resolveParticleSprite(textureSlots, missingModelBaker);
        this.missingModel = new BlockStateModel(){

            public void collectParts(RandomSource random, List<BlockModelPart> output) {
                output.add(new BlockModelPart(){

                    public List<BakedQuad> getQuads(@Nullable Direction direction) {
                        return quadCollection.getQuads(direction);
                    }

                    public boolean useAmbientOcclusion() {
                        return DynamicModelProvider.this.resolvedMissingModel.getTopAmbientOcclusion();
                    }

                    public TextureAtlasSprite particleIcon() {
                        return particleSprite;
                    }
                });
            }

            public TextureAtlasSprite particleIcon() {
                return particleSprite;
            }
        };
        this.missingItemModel = new MissingItemModel(quadCollection.getAll(), new ModelRenderProperties(this.resolvedMissingModel.getTopGuiLight().lightLikeBlock(), particleSprite, this.resolvedMissingModel.getTopTransforms()));
        try {
            Class.forName("net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Map<Identifier, StateDefinition<Block, BlockState>> static_definitions = BlockStateDefinitionsAccessor.getStaticDefinitions();
        for (Map.Entry<Identifier, StateDefinition<Block, BlockState>> definition : static_definitions.entrySet()) {
            StateDefinition<Block, BlockState> fakeStateDefinitions = definition.getValue();
            Identifier identifier = definition.getKey();
            Identifier modelIdentifier = identifier.withPath("block/" + identifier.getPath());
            Optional unbakedModel = (Optional)this.loadedBlockModels.getUnchecked((Object)modelIdentifier);
            for (BlockState fakeState : fakeStateDefinitions.getPossibleStates()) {
                Optional bakedModel = unbakedModel.flatMap(model -> {
                    Optional optLoadedModels = (Optional)this.loadedStateDefinitions.getUnchecked((Object)identifier);
                    return optLoadedModels.map(loadedModels -> (BlockStateModel.UnbakedRoot)loadedModels.models().get(fakeState)).map(unbakedRoot -> this.bakeModel((BlockStateModel.UnbakedRoot)unbakedRoot, fakeState));
                });
                if (bakedModel.isPresent()) {
                    this.mrlModelOverrides.put(fakeState, (BlockStateModel)bakedModel.get());
                    continue;
                }
                ModernFix.LOGGER.error("Failed to load BlockStateModel for static definition {}, state {}", (Object)identifier, (Object)fakeState);
            }
        }
        ModernFix.LOGGER.info("Loaded {} BlockState -> BlockStateModel overrides", (Object)this.mrlModelOverrides.size());
    }

    public BlockStateModel getMissingBakedModel() {
        return this.missingModel;
    }

    public ItemModel getMissingItemModel() {
        return this.missingItemModel;
    }

    public Map<BlockState, BlockStateModel> getTopLevelEmulatedRegistry() {
        return new EmulatedRegistry<BlockState, BlockStateModel>(BlockState.class, this.loadedBakedModels, BlockStateSet::instance, this.mrlModelOverrides);
    }

    public Map<BlockState, BlockStateModel> getFastTopLevelEmulatedRegistry() {
        final Map<BlockState, BlockStateModel> dynamicRegistry = this.getTopLevelEmulatedRegistry();
        return new ForwardingMap<BlockState, BlockStateModel>(){

            protected Map<BlockState, BlockStateModel> delegate() {
                return dynamicRegistry;
            }

            public BlockStateModel get(Object key) {
                IModelHoldingBlockState state;
                BlockStateModel result;
                if (key instanceof IModelHoldingBlockState && (result = (state = (IModelHoldingBlockState)key).mfix$getModel()) != null) {
                    return result;
                }
                result = dynamicRegistry.getOrDefault(key, DynamicModelProvider.this.getMissingBakedModel());
                if (key instanceof IModelHoldingBlockState) {
                    state = (IModelHoldingBlockState)key;
                    state.mfix$setModel(result);
                }
                return result;
            }
        };
    }

    public Map<Identifier, ItemModel> getItemModelEmulatedRegistry() {
        return new EmulatedRegistry<Identifier, ItemModel>(Identifier.class, this.loadedItemModels, () -> ((DefaultedRegistry)BuiltInRegistries.ITEM).keySet(), this.itemStackModelOverrides);
    }

    public Map<Identifier, ClientItem.Properties> getItemPropertiesEmulatedRegistry() {
        return Maps.transformValues(new EmulatedRegistry<Identifier, ClientItem>(Identifier.class, this.loadedClientItemProperties, () -> ((DefaultedRegistry)BuiltInRegistries.ITEM).keySet(), Map.of()), ClientItem::properties);
    }

    private <K, V> LoadingCache<K, Optional<V>> makeLoadingCache(final Function<K, Optional<V>> loadingFunction) {
        return CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.MINUTES).maximumSize(1000L).concurrencyLevel(8).softValues().build(new CacheLoader<K, Optional<V>>(this){

            public Optional<V> load(K key) {
                return (Optional)loadingFunction.apply(key);
            }
        });
    }

    private Optional<BlockStateModelLoader.LoadedModels> loadBlockStateDefinition(Identifier location) {
        StateDefinition<Block, BlockState> stateDefinition = this.stateMapper.apply(location);
        if (stateDefinition == null) {
            return Optional.empty();
        }
        if (DEBUG_DYNAMIC_MODEL_LOADING) {
            ModernFix.LOGGER.info("Loading blockstate definition '{}'", (Object)location);
        }
        List resources = this.resourceManager.getResourceStack(Identifier.fromNamespaceAndPath((String)location.getNamespace(), (String)("blockstates/" + location.getPath() + ".json")));
        ArrayList<BlockStateModelLoader.LoadedBlockModelDefinition> loadedDefinitions = new ArrayList<BlockStateModelLoader.LoadedBlockModelDefinition>(resources.size());
        for (Resource resource : resources) {
            try {
                BufferedReader reader = resource.openAsReader();
                try {
                    JsonObject jsonObject = GsonHelper.parse((Reader)reader);
                    BlockModelDefinition blockModelDefinition = (BlockModelDefinition)((Pair)BlockModelDefinition.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow()).getFirst();
                    loadedDefinitions.add(new BlockStateModelLoader.LoadedBlockModelDefinition(resource.sourcePackId(), blockModelDefinition));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                ModernFix.LOGGER.error("Failed to load blockstate definition {} from pack '{}'", (Object)location, (Object)resource.sourcePackId(), (Object)e);
            }
        }
        HashMap<BlockState, BlockStateModel.UnbakedRoot> loadedModels = new HashMap<BlockState, BlockStateModel.UnbakedRoot>(BlockStateModelLoaderMixin.mfix$invokeLoadBlockStateDefinitionStack(location, stateDefinition, loadedDefinitions).models());
        if (!this.pluginList.isEmpty()) {
            loadedModels.replaceAll((mrl, oldModel) -> {
                BlockStateModel.UnbakedRoot ubm = oldModel;
                for (DynamicModelPlugin plugin : this.pluginList) {
                    ubm = plugin.modifyBlockModelOnLoad((BlockStateModel.UnbakedRoot)oldModel, (BlockState)mrl);
                }
                return ubm;
            });
        }
        return Optional.of(new BlockStateModelLoader.LoadedModels(loadedModels));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockStateModel bakeModel(BlockStateModel.UnbakedRoot model, BlockState mrl) {
        if (DEBUG_DYNAMIC_MODEL_LOADING) {
            ModernFix.LOGGER.info("Baking model '{}'", (Object)mrl);
        }
        DynamicModelProvider dynamicModelProvider = this;
        synchronized (dynamicModelProvider) {
            model.resolveDependencies(dep -> {});
            DynamicBaker modelBaker = new DynamicBaker(() -> ((BlockState)mrl).toString());
            for (DynamicModelPlugin plugin : this.pluginList) {
                model = plugin.modifyBlockModelBeforeBake(model, mrl, modelBaker);
            }
            BlockStateModel bakedModel = model.bake(mrl, (ModelBaker)modelBaker);
            for (DynamicModelPlugin plugin : this.pluginList) {
                bakedModel = plugin.modifyBlockModelAfterBake(bakedModel, model, mrl, modelBaker);
            }
            return bakedModel;
        }
    }

    private Optional<BlockStateModel> loadBakedModel(BlockState state) {
        BlockStateModel override = this.mrlModelOverrides.get(state);
        if (override != null) {
            return Optional.of(override);
        }
        Optional<BlockStateModel.UnbakedRoot> unbakedModelOpt = Optional.ofNullable(this.unbakedBlockStateModelOverrides.get(state)).map(BlockStateModel.Unbaked::asRoot);
        if (unbakedModelOpt.isEmpty()) {
            Optional optLoadedModels = (Optional)this.loadedStateDefinitions.getUnchecked((Object)state.getBlock().builtInRegistryHolder().key().identifier());
            unbakedModelOpt = optLoadedModels.map(loadedModels -> (BlockStateModel.UnbakedRoot)loadedModels.models().get(state));
        }
        return unbakedModelOpt.map(unbakedModel -> this.bakeModel((BlockStateModel.UnbakedRoot)unbakedModel, state));
    }

    private Optional<UnbakedModel> loadBlockModelDefault(Identifier location) {
        if (DEBUG_DYNAMIC_MODEL_LOADING) {
            ModernFix.LOGGER.info("Loading block model '{}'", (Object)location);
        }
        if (location.equals((Object)ItemModelGenerator.GENERATED_ITEM_MODEL_ID)) {
            return Optional.of(this.itemModelGenerator);
        }
        if (location.equals((Object)MissingBlockModel.LOCATION)) {
            return Optional.of(this.unbakedMissingModel);
        }
        Optional resource = this.resourceManager.getResource(Identifier.fromNamespaceAndPath((String)location.getNamespace(), (String)("models/" + location.getPath() + ".json")));
        if (resource.isPresent()) {
            Optional<BlockModel> optional;
            block12: {
                BufferedReader reader = ((Resource)resource.get()).openAsReader();
                try {
                    BlockModel blockModel = BlockModel.fromStream((Reader)reader);
                    optional = Optional.of(blockModel);
                    if (reader == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        ModernFix.LOGGER.error("Failed to load block model {} from '{}'", (Object)location, (Object)((Resource)resource.get()).sourcePackId(), (Object)e);
                        return Optional.empty();
                    }
                }
                ((Reader)reader).close();
            }
            return optional;
        }
        ModernFix.LOGGER.warn("Model '{}' does not exist in any resource packs", (Object)location);
        return Optional.empty();
    }

    private Optional<UnbakedModel> loadBlockModel(Identifier location) {
        Optional<UnbakedModel> value = this.loadBlockModelDefault(location);
        for (DynamicModelPlugin plugin : this.pluginList) {
            value = plugin.modifyModelOnLoad(value, location);
        }
        return value;
    }

    private Optional<ModelDiscovery.ModelWrapper> resolveBlockModel(Identifier location) {
        Optional unbakedOpt = (Optional)this.loadedBlockModels.getUnchecked((Object)location);
        if (unbakedOpt.isEmpty()) {
            return Optional.empty();
        }
        ModelDiscovery.ModelWrapper wrapper = ModelWrapperInvoker.mfix$invokeCtor(location, (UnbakedModel)unbakedOpt.get(), true);
        Identifier parent = wrapper.wrapped().parent();
        if (parent != null) {
            Optional resolvedParentOpt;
            try {
                resolvedParentOpt = (Optional)this.resolvedBlockModels.getUnchecked((Object)parent);
            }
            catch (Exception e) {
                ModernFix.LOGGER.error("Error while resolving model '{}'", (Object)location, (Object)e);
                return Optional.empty();
            }
            if (resolvedParentOpt.isPresent()) {
                wrapper.parent = (ModelDiscovery.ModelWrapper)resolvedParentOpt.get();
            }
        }
        return Optional.of(wrapper);
    }

    private Optional<ClientItem> loadClientItemProperties(Identifier location) {
        Optional resource;
        if (DEBUG_DYNAMIC_MODEL_LOADING) {
            ModernFix.LOGGER.info("Loading client item '{}'", (Object)location);
        }
        if ((resource = this.resourceManager.getResource(Identifier.fromNamespaceAndPath((String)location.getNamespace(), (String)("items/" + location.getPath() + ".json")))).isPresent()) {
            Optional<ClientItem> optional;
            block10: {
                BufferedReader reader = ((Resource)resource.get()).openAsReader();
                try {
                    ClientItem clientItem = (ClientItem)ClientItem.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)reader)).getOrThrow();
                    optional = Optional.of(clientItem);
                    if (reader == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        ModernFix.LOGGER.error("Failed to load client item {} from '{}'", (Object)location, (Object)((Resource)resource.get()).sourcePackId(), (Object)e);
                        return Optional.empty();
                    }
                }
                ((Reader)reader).close();
            }
            return optional;
        }
        ModernFix.LOGGER.warn("Client item '{}' does not exist in any resource packs", (Object)location);
        return Optional.empty();
    }

    private Optional<ItemModel> loadItemModel(Identifier location) {
        ItemModel override;
        if (DEBUG_DYNAMIC_MODEL_LOADING) {
            ModernFix.LOGGER.info("Loading item model '{}'", (Object)location);
        }
        if ((override = this.itemStackModelOverrides.get(location)) != null) {
            return Optional.of(override);
        }
        return ((Optional)this.loadedClientItemProperties.getUnchecked((Object)location)).map(clientItem -> {
            ItemModel.BakingContext bakingContext = new ItemModel.BakingContext((ModelBaker)new DynamicBaker(() -> ((Identifier)location).toString()), this.entityModelSet, this.materialSet, this.skinRenderCache, this.missingItemModel, clientItem.registrySwapper());
            return clientItem.model().bake(bakingContext);
        });
    }

    LoadingCache<BlockState, Optional<BlockStateModel>> getBlockStateCache() {
        return this.loadedBakedModels;
    }

    private static class EmulatedRegistry<K, V>
    implements Map<K, V> {
        private final LoadingCache<K, Optional<V>> realCache;
        private final Supplier<Set<K>> keys;
        private final Map<K, V> overrides;
        private final Class<K> keyClass;

        public EmulatedRegistry(Class<K> keyClass, LoadingCache<K, Optional<V>> realCache, Supplier<Set<K>> keys, Map<K, V> overrides) {
            this.keyClass = keyClass;
            this.realCache = realCache;
            this.keys = keys;
            this.overrides = overrides;
        }

        @Override
        public V get(Object key) {
            if (this.keyClass.isAssignableFrom(key.getClass())) {
                return ((Optional)this.realCache.getUnchecked(key)).orElse(null);
            }
            return null;
        }

        @Override
        public V getOrDefault(Object key, V defaultValue) {
            if (this.keyClass.isAssignableFrom(key.getClass())) {
                return ((Optional)this.realCache.getUnchecked(key)).orElse(defaultValue);
            }
            return defaultValue;
        }

        @Override
        public V put(K key, V value) {
            V oldValue = ((Optional)this.realCache.getUnchecked(key)).orElse(null);
            this.overrides.put(key, value);
            this.realCache.invalidate(key);
            return oldValue;
        }

        @Override
        public V remove(Object key) {
            this.overrides.remove(key);
            this.realCache.invalidate(key);
            return null;
        }

        @Override
        public void putAll(@NotNull Map<? extends K, ? extends V> m) {
            m.forEach(this::put);
        }

        @Override
        public void clear() {
            this.overrides.clear();
            this.realCache.invalidateAll();
        }

        @Override
        @NotNull
        public Set<K> keySet() {
            return this.keys.get();
        }

        @Override
        @NotNull
        public Collection<V> values() {
            return Collections.emptyList();
        }

        @Override
        public int size() {
            return this.keys.get().size();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.keys.get().contains(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        @NotNull
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return Iterators.transform(keys.get().iterator(), key -> new Map.Entry<K, V>(){

                        @Override
                        public K getKey() {
                            return key;
                        }

                        @Override
                        public V getValue() {
                            return this.get(key);
                        }

                        @Override
                        public V setValue(V value) {
                            return this.put(key, value);
                        }
                    });
                }

                @Override
                public int size() {
                    return keys.get().size();
                }
            };
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            for (K location : this.keys.get()) {
                V existing;
                V replacement;
                boolean needsReplacement;
                try {
                    needsReplacement = function.apply(location, null) != null;
                }
                catch (Throwable e) {
                    needsReplacement = true;
                }
                if (!needsReplacement || (replacement = function.apply(location, existing = this.get(location))) == existing) continue;
                this.put(location, replacement);
            }
        }
    }

    private class DynamicBaker
    implements ModelBaker {
        private final ModelDebugName modelDebugName;

        private DynamicBaker(ModelDebugName modelDebugName) {
            this.modelDebugName = modelDebugName;
        }

        public ResolvedModel getModel(Identifier location) {
            return (ResolvedModel)((Optional)DynamicModelProvider.this.resolvedBlockModels.getUnchecked((Object)location)).orElse(DynamicModelProvider.this.resolvedMissingModel);
        }

        public BlockModelPart missingBlockModelPart() {
            return null;
        }

        public SpriteGetter sprites() {
            return DynamicModelProvider.this.textureGetter;
        }

        public ModelBaker.PartCache parts() {
            return DynamicModelProvider.this.partCache;
        }

        public <T> T compute(ModelBaker.SharedOperationKey<T> key) {
            return (T)key.compute((ModelBaker)this);
        }
    }

    public static interface DynamicModelPlugin {
        public Optional<UnbakedModel> modifyModelOnLoad(Optional<UnbakedModel> var1, Identifier var2);

        public BlockStateModel.UnbakedRoot modifyBlockModelOnLoad(BlockStateModel.UnbakedRoot var1, BlockState var2);

        public UnbakedModel modifyModelBeforeBake(UnbakedModel var1, Identifier var2, ModelState var3, ModelBaker var4);

        public BlockStateModel.UnbakedRoot modifyBlockModelBeforeBake(BlockStateModel.UnbakedRoot var1, BlockState var2, ModelBaker var3);

        public BlockStateModel modifyBlockModelAfterBake(BlockStateModel var1, BlockStateModel.UnbakedRoot var2, BlockState var3, ModelBaker var4);
    }

    public static interface ModelManagerExtension {
        public DynamicModelProvider mfix$getModelProvider();
    }
}

