/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.neoforge.init;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.DebugScreenOverlay;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.Identifier;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import org.embeddedt.modernfix.ModernFixClient;
import org.embeddedt.modernfix.screen.ModernFixConfigScreen;

public class ModernFixClientForge {
    private static ModernFixClient commonMod;
    public static KeyMapping.Category MODERNFIX_KEYS;
    private KeyMapping configKey;

    public ModernFixClientForge(ModContainer modContainer, IEventBus modBus) {
        commonMod = new ModernFixClient();
        modBus.addListener(this::keyBindRegister);
        modBus.addListener(this::onClientSetup);
        modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(mc, screen) -> new ModernFixConfigScreen(screen)));
    }

    private void keyBindRegister(RegisterKeyMappingsEvent event) {
        this.configKey = new KeyMapping("key.modernfix.config", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, InputConstants.UNKNOWN, MODERNFIX_KEYS);
        event.register(this.configKey);
    }

    private void onClientSetup(FMLClientSetupEvent event) {
    }

    @SubscribeEvent
    public void onConfigKey(ClientTickEvent.Pre event) {
        if (this.configKey != null && this.configKey.consumeClick()) {
            Minecraft.getInstance().setScreen((Screen)new ModernFixConfigScreen(Minecraft.getInstance().screen));
        }
    }

    @SubscribeEvent
    public void onDisconnect(LevelEvent.Unload event) {
        if (event.getLevel().isClientSide()) {
            DebugScreenOverlay overlay = Minecraft.getInstance().getDebugOverlay();
            Minecraft.getInstance().execute(() -> ((DebugScreenOverlay)overlay).clearChunkCache());
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartedEvent event) {
        commonMod.onServerStarted(event.getServer());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRenderTickEnd(RenderFrameEvent.Post event) {
        commonMod.onRenderTickEnd();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onTags(TagsUpdatedEvent e) {
        commonMod.onTagsUpdated();
    }

    private static /* synthetic */ void lambda$onClientSetup$1() {
        ModLoader.addLoadingIssue((ModLoadingIssue)ModLoadingIssue.warning((String)"modernfix.connectedness_dynresoruces", (Object[])new Object[0]));
    }

    static {
        MODERNFIX_KEYS = KeyMapping.Category.register((Identifier)Identifier.fromNamespaceAndPath((String)"modernfix", (String)"key.modernfix"));
    }
}

